/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.Tracer;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryMessage;

public class SpanUtils {
    private static final String TAG_AXON_ID = "axon.message.id";
    private static final String TAG_AXON_AGGREGATE_ID = "axon.message.aggregate-identifier";
    private static final String TAG_AXON_MESSAGE_TYPE = "axon.message.type";
    private static final String TAG_AXON_PAYLOAD_TYPE = "axon.message.payload-type";
    private static final String TAG_AXON_MESSAGE_NAME = "axon.message.message-name";

    @Deprecated
    public static Tracer.SpanBuilder withMessageTags(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        Tracer.SpanBuilder sb = spanBuilder.withTag(TAG_AXON_ID, message.getIdentifier()).withTag(TAG_AXON_MESSAGE_TYPE, SpanUtils.resolveMessageType(message)).withTag(TAG_AXON_PAYLOAD_TYPE, message.getPayloadType().getName());
        if (message instanceof CommandMessage || message instanceof QueryMessage) {
            return sb.withTag(TAG_AXON_MESSAGE_NAME, SpanUtils.messageName(message));
        }
        if (message instanceof DomainEventMessage) {
            return sb.withTag(TAG_AXON_AGGREGATE_ID, ((DomainEventMessage)message).getAggregateIdentifier());
        }
        return sb;
    }

    @Deprecated
    public static Tracer.SpanBuilder withQueryMessageTags(Tracer.SpanBuilder spanBuilder, Message<?> queryMessage, String queryName) {
        return spanBuilder.withTag(TAG_AXON_ID, queryMessage.getIdentifier()).withTag(TAG_AXON_MESSAGE_TYPE, QueryMessage.class.getSimpleName()).withTag(TAG_AXON_PAYLOAD_TYPE, queryMessage.getPayloadType().getName()).withTag(TAG_AXON_MESSAGE_NAME, queryName);
    }

    public static String resolveMessageType(Message<?> message) {
        Class<Message> clazz = Message.class;
        if (message instanceof QueryMessage) {
            clazz = QueryMessage.class;
        } else if (message instanceof CommandMessage) {
            clazz = CommandMessage.class;
        } else if (message instanceof EventMessage) {
            clazz = EventMessage.class;
        }
        return clazz.getSimpleName();
    }

    public static String messageName(Message<?> message) {
        if (message instanceof CommandMessage) {
            return SpanUtils.messageName(message.getPayloadType(), ((CommandMessage)message).getCommandName());
        }
        if (message instanceof QueryMessage) {
            return SpanUtils.messageName(message.getPayloadType(), ((QueryMessage)message).getQueryName());
        }
        return message.getPayloadType().getSimpleName();
    }

    static String messageName(Class<?> payloadType, String name) {
        if (!payloadType.getName().equals(name)) {
            return name;
        }
        return payloadType.getSimpleName();
    }
}

