/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.Span;
import org.axonframework.common.Registration;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TraceableSubscriptionQueryResult<I, U>
implements SubscriptionQueryResult<I, U> {
    private final Mono<I> initialResult;
    private final Flux<U> updates;
    private final Registration registrationDelegate;
    private final Span span;

    public TraceableSubscriptionQueryResult(SubscriptionQueryResult<I, U> subscriptionQueryResult, Span span) {
        this.initialResult = subscriptionQueryResult.initialResult();
        this.updates = subscriptionQueryResult.updates();
        this.registrationDelegate = subscriptionQueryResult;
        this.span = span;
    }

    public Mono<I> initialResult() {
        this.span.log("initialResultReceived");
        return this.initialResult;
    }

    public Flux<U> updates() {
        return this.updates.doOnEach(ignored -> this.span.log("updateReceived"));
    }

    public boolean cancel() {
        this.span.log("subscriptionClosed");
        this.span.finish();
        return this.registrationDelegate.cancel();
    }
}

