/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.callbacks.FailureLoggingCallback;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.extensions.tracing.MessageTagBuilderService;
import org.axonframework.extensions.tracing.SpanUtils;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingCommandGateway
implements CommandGateway {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Tracer tracer;
    private final CommandGateway delegate;
    private final MessageTagBuilderService messageTagBuilderService;

    public static Builder builder() {
        return new Builder();
    }

    protected TracingCommandGateway(Builder builder) {
        builder.validate();
        this.tracer = builder.tracer;
        this.delegate = builder.buildDelegateCommandGateway();
        this.messageTagBuilderService = builder.messageTagBuilderService;
    }

    public <C, R> void send(C command, CommandCallback<? super C, ? super R> callback) {
        CommandMessage cmd = GenericCommandMessage.asCommandMessage(command);
        this.sendWithSpan("send_" + SpanUtils.messageName(cmd), cmd, childSpan -> {
            CompletableFuture resultReceived = new CompletableFuture();
            this.delegate.send((Object)cmd, (commandMessage, commandResultMessage) -> {
                try (Scope ignored = this.tracer.activateSpan(childSpan);){
                    childSpan.log("resultReceived");
                    callback.onResult(commandMessage, commandResultMessage);
                    childSpan.log("afterCallbackInvocation");
                }
                finally {
                    resultReceived.complete(null);
                }
            });
            childSpan.log("dispatchComplete");
            resultReceived.thenRun(() -> ((Span)childSpan).finish());
        });
    }

    public <R> R sendAndWait(Object command) {
        return this.doSendAndExtract(command, FutureCallback::getResult);
    }

    public <R> R sendAndWait(Object command, long timeout, TimeUnit unit) {
        return this.doSendAndExtract(command, f -> f.getResult(timeout, unit));
    }

    public <R> CompletableFuture<R> send(Object command) {
        FutureCallback callback = new FutureCallback();
        this.send((Object)command, (CommandCallback)new FailureLoggingCallback(logger, (CommandCallback)callback));
        CompletableFuture result = new CompletableFuture();
        callback.exceptionally(GenericCommandResultMessage::asCommandResultMessage).thenAccept(r -> {
            try {
                if (r.isExceptional()) {
                    result.completeExceptionally(r.exceptionResult());
                } else {
                    result.complete(r.getPayload());
                }
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    private <R> R doSendAndExtract(Object command, Function<FutureCallback<Object, R>, CommandResultMessage<? extends R>> resultExtractor) {
        FutureCallback futureCallback = new FutureCallback();
        CommandMessage cmd = GenericCommandMessage.asCommandMessage((Object)command);
        this.sendWithSpan("sendAndWait_" + SpanUtils.messageName(cmd), cmd, childSpan -> {
            this.delegate.send((Object)cmd, (CommandCallback)futureCallback);
            futureCallback.thenRun(() -> childSpan.log("resultReceived"));
            childSpan.log("dispatchComplete");
            futureCallback.thenRun(() -> ((Span)childSpan).finish());
        });
        CommandResultMessage<? extends R> commandResultMessage = resultExtractor.apply(futureCallback);
        if (commandResultMessage.isExceptional()) {
            throw this.asRuntime(commandResultMessage.exceptionResult());
        }
        return (R)commandResultMessage.getPayload();
    }

    private void sendWithSpan(String operation, CommandMessage<?> command, SpanConsumer consumer) {
        Tracer.SpanBuilder spanBuilder = this.messageTagBuilderService.withCommandMessageTags(this.tracer.buildSpan(operation), command).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span childSpan = spanBuilder.start();
        try (Scope ignored = this.tracer.activateSpan(childSpan);){
            consumer.accept(childSpan);
        }
    }

    private RuntimeException asRuntime(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new CommandExecutionException("An exception occurred while executing a command", e);
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        return this.delegate.registerDispatchInterceptor(dispatchInterceptor);
    }

    public static class Builder {
        private Tracer tracer;
        private CommandBus delegateBus;
        private CommandGateway delegateGateway;
        private MessageTagBuilderService messageTagBuilderService = MessageTagBuilderService.defaultService();

        public Builder tracer(Tracer tracer) {
            BuilderUtils.assertNonNull((Object)tracer, (String)"Tracer may not be null");
            this.tracer = tracer;
            return this;
        }

        public Builder delegateCommandBus(CommandBus delegateBus) {
            BuilderUtils.assertNonNull((Object)delegateBus, (String)"Delegate CommandBus may not be null");
            this.delegateBus = delegateBus;
            return this;
        }

        public Builder delegateCommandGateway(CommandGateway delegateGateway) {
            BuilderUtils.assertNonNull((Object)delegateGateway, (String)"Delegate CommandGateway may not be null");
            this.delegateGateway = delegateGateway;
            return this;
        }

        public Builder messageTagBuilderService(MessageTagBuilderService messageTagBuilderService) {
            BuilderUtils.assertNonNull((Object)messageTagBuilderService, (String)"MessageTagBuilderService may not be null");
            this.messageTagBuilderService = messageTagBuilderService;
            return this;
        }

        public TracingCommandGateway build() {
            return new TracingCommandGateway(this);
        }

        private CommandGateway buildDelegateCommandGateway() {
            return this.delegateGateway != null ? this.delegateGateway : DefaultCommandGateway.builder().commandBus(this.delegateBus).build();
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.tracer, (String)"The Tracer is a hard requirement and should be provided");
            if (this.delegateBus == null) {
                BuilderUtils.assertNonNull((Object)this.delegateGateway, (String)"The delegate CommandGateway is a hard requirement and should be provided");
                return;
            }
            BuilderUtils.assertNonNull((Object)this.delegateBus, (String)"The delegate CommandBus is a hard requirement to create a delegate CommandGateway and should be provided");
        }
    }

    @FunctionalInterface
    private static interface SpanConsumer {
        public void accept(Span var1);
    }
}

