/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.axonframework.extensions.tracing.MapInjector;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.CorrelationDataProvider;

public class TracingProvider
implements CorrelationDataProvider {
    private final Tracer tracer;

    public TracingProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    public Map<String, ?> correlationDataFor(Message<?> message) {
        return Optional.ofNullable(this.tracer.activeSpan()).map(activeSpan -> {
            MapInjector injector = new MapInjector();
            this.tracer.inject(activeSpan.context(), Format.Builtin.TEXT_MAP, (Object)injector);
            return injector.getMetaData();
        }).orElseGet(Collections::emptyMap);
    }
}

