/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.extensions.tracing.MessageTagBuilderService;
import org.axonframework.extensions.tracing.SpanUtils;
import org.axonframework.extensions.tracing.TraceableSubscriptionQueryResult;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericStreamingQueryMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class TracingQueryGateway
implements QueryGateway {
    private final Tracer tracer;
    private final QueryGateway delegate;
    private final MessageTagBuilderService messageTagBuilderService;

    protected TracingQueryGateway(Builder builder) {
        builder.validate();
        this.tracer = builder.tracer;
        this.delegate = builder.buildDelegateQueryGateway();
        this.messageTagBuilderService = builder.messageTagBuilderService;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <R, Q> CompletableFuture<R> query(String queryName, Q query, ResponseType<R> responseType) {
        GenericQueryMessage queryMessage = new GenericQueryMessage(GenericMessage.asMessage(query), queryName, responseType);
        return this.getWithSpan("query_" + SpanUtils.messageName(ObjectUtils.nullSafeTypeOf(query), queryName), (QueryMessage<?, R>)queryMessage, arg_0 -> this.lambda$query$1(queryName, (QueryMessage)queryMessage, responseType, arg_0));
    }

    public <R, Q> Stream<R> scatterGather(String queryName, Q query, ResponseType<R> responseType, long timeout, TimeUnit timeUnit) {
        GenericQueryMessage queryMessage = new GenericQueryMessage(GenericMessage.asMessage(query), queryName, responseType);
        return this.getWithSpan("scatterGather_" + SpanUtils.messageName(ObjectUtils.nullSafeTypeOf(query), queryName), (QueryMessage<?, R>)queryMessage, arg_0 -> this.lambda$scatterGather$3(queryName, (QueryMessage)queryMessage, responseType, timeout, timeUnit, arg_0));
    }

    public <R, Q> Publisher<R> streamingQuery(Q query, Class<R> responseType) {
        return this.streamingQuery(QueryMessage.queryName(query), query, responseType);
    }

    public <R, Q> Publisher<R> streamingQuery(String queryName, Q query, Class<R> responseType) {
        GenericStreamingQueryMessage queryMessagesMessage = new GenericStreamingQueryMessage(query, queryName, responseType);
        return (Publisher)this.getWithSpan("streamingQuery_" + SpanUtils.messageName(ObjectUtils.nullSafeTypeOf(query), queryName), (QueryMessage<?, R>)queryMessagesMessage, childSpan -> Flux.from((Publisher)this.delegate.streamingQuery(queryName, (Object)queryMessagesMessage, responseType)).doOnSubscribe(unused -> childSpan.log("subscriptionStarted")).doOnNext(unused -> childSpan.log("answerReceived")).doFinally(unused -> {
            childSpan.log("subscriptionTerminated");
            childSpan.finish();
        }));
    }

    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(String queryName, Q query, ResponseType<I> initialResponseType, ResponseType<U> updateResponseType, int updateBufferSize) {
        GenericSubscriptionQueryMessage queryMessage = new GenericSubscriptionQueryMessage(GenericMessage.asMessage(query), queryName, initialResponseType, updateResponseType);
        return this.getWithSpan("subscriptionQuery_" + SpanUtils.messageName(ObjectUtils.nullSafeTypeOf(query), queryName), (QueryMessage)queryMessage, arg_0 -> this.lambda$subscriptionQuery$8(queryName, (SubscriptionQueryMessage)queryMessage, initialResponseType, updateResponseType, updateBufferSize, arg_0));
    }

    @Deprecated
    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(String queryName, Q query, ResponseType<I> initialResponseType, ResponseType<U> updateResponseType, SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        return this.subscriptionQuery(queryName, query, initialResponseType, updateResponseType, updateBufferSize);
    }

    private <R, T> T getWithSpan(String operation, QueryMessage<?, R> query, SpanSupplier<T> supplier) {
        Tracer.SpanBuilder spanBuilder = this.messageTagBuilderService.withQueryMessageTags(this.tracer.buildSpan(operation), query).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span childSpan = spanBuilder.start();
        try (Scope ignored = this.tracer.activateSpan(childSpan);){
            T t = supplier.get(childSpan);
            return t;
        }
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super QueryMessage<?, ?>> dispatchInterceptor) {
        return this.delegate.registerDispatchInterceptor(dispatchInterceptor);
    }

    private /* synthetic */ TraceableSubscriptionQueryResult lambda$subscriptionQuery$8(String queryName, SubscriptionQueryMessage queryMessage, ResponseType initialResponseType, ResponseType updateResponseType, int updateBufferSize, Span childSpan) {
        SubscriptionQueryResult subscriptionQueryResult = this.delegate.subscriptionQuery(queryName, (Object)queryMessage, initialResponseType, updateResponseType, updateBufferSize);
        return new TraceableSubscriptionQueryResult(subscriptionQueryResult, childSpan);
    }

    private /* synthetic */ Stream lambda$scatterGather$3(String queryName, QueryMessage queryMessage, ResponseType responseType, long timeout, TimeUnit timeUnit, Span childSpan) {
        return (Stream)this.delegate.scatterGather(queryName, (Object)queryMessage, responseType, timeout, timeUnit).onClose(() -> {
            childSpan.log("resultReceived");
            childSpan.finish();
        });
    }

    private /* synthetic */ CompletableFuture lambda$query$1(String queryName, QueryMessage queryMessage, ResponseType responseType, Span childSpan) {
        return this.delegate.query(queryName, (Object)queryMessage, responseType).whenComplete((r, e) -> {
            childSpan.log("resultReceived");
            childSpan.finish();
        });
    }

    public static class Builder {
        private Tracer tracer;
        private QueryBus delegateBus;
        private QueryGateway delegateGateway;
        private MessageTagBuilderService messageTagBuilderService = MessageTagBuilderService.defaultService();

        public Builder tracer(Tracer tracer) {
            BuilderUtils.assertNonNull((Object)tracer, (String)"Tracer may not be null");
            this.tracer = tracer;
            return this;
        }

        public Builder delegateQueryBus(QueryBus delegateBus) {
            BuilderUtils.assertNonNull((Object)delegateBus, (String)"Delegate QueryBus may not be null");
            this.delegateBus = delegateBus;
            return this;
        }

        public Builder delegateQueryGateway(QueryGateway delegateGateway) {
            BuilderUtils.assertNonNull((Object)delegateGateway, (String)"Delegate QueryGateway may not be null");
            this.delegateGateway = delegateGateway;
            return this;
        }

        public Builder messageTagBuilderService(MessageTagBuilderService messageTagBuilderService) {
            BuilderUtils.assertNonNull((Object)messageTagBuilderService, (String)"MessageTagBuilderService may not be null");
            this.messageTagBuilderService = messageTagBuilderService;
            return this;
        }

        public TracingQueryGateway build() {
            return new TracingQueryGateway(this);
        }

        private QueryGateway buildDelegateQueryGateway() {
            return this.delegateGateway != null ? this.delegateGateway : DefaultQueryGateway.builder().queryBus(this.delegateBus).build();
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.tracer, (String)"The Tracer is a hard requirement and should be provided");
            if (this.delegateBus == null) {
                BuilderUtils.assertNonNull((Object)this.delegateGateway, (String)"The delegate QueryGateway is a hard requirement and should be provided");
                return;
            }
            BuilderUtils.assertNonNull((Object)this.delegateBus, (String)"The delegate QueryBus is a hard requirement to create a delegate QueryGateway and should be provided");
        }
    }

    @FunctionalInterface
    private static interface SpanSupplier<T> {
        public T get(Span var1);
    }
}

