/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.firestarter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.firestarter.decorators.FireStarterCommandBus;
import org.axonframework.firestarter.decorators.FireStarterEventStore;
import org.axonframework.firestarter.decorators.FireStarterQueryBus;
import org.axonframework.firestarter.decorators.FireStarterSagaStore;
import org.axonframework.firestarter.decorators.FireStarterTokenStore;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.queryhandling.QueryBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/axonframework/firestarter/FireStarterBeanPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "postProcessBeforeInitialization", "", "bean", "beanName", "", "firestarter-spring-starter"})
public final class FireStarterBeanPostProcessor
implements BeanPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Nullable
    public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        if (bean instanceof EventStore) {
            this.logger.info("Decorating EventStore with Axon Framework Firestarter");
            return new FireStarterEventStore((EventStore)bean);
        }
        if (bean instanceof QueryBus) {
            this.logger.info("Decorating QueryBus with Axon Framework Firestarter");
            return new FireStarterQueryBus((QueryBus)bean);
        }
        if (bean instanceof CommandBus) {
            this.logger.info("Decorating CommandBus with Axon Framework Firestarter");
            return new FireStarterCommandBus((CommandBus)bean);
        }
        if (bean instanceof SagaStore) {
            this.logger.info("Decorating SagaRepository with Axon Framework Firestarter");
            return new FireStarterSagaStore((SagaStore)bean);
        }
        if (bean instanceof TokenStore) {
            this.logger.info("Decorating TokenStore with Axon Framework Firestarter");
            return new FireStarterTokenStore((TokenStore)bean);
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }
}

