/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.firestarter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.firestarter.FireStarterSettingsHolder;
import org.axonframework.firestarter.decorators.FireStarterCommandBus;
import org.axonframework.firestarter.decorators.FireStarterEventStore;
import org.axonframework.firestarter.decorators.FireStarterQueryBus;
import org.axonframework.firestarter.decorators.FireStarterSagaStore;
import org.axonframework.firestarter.decorators.FireStarterTokenStore;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.queryhandling.QueryBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/axonframework/firestarter/FireStarterBeanPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "settingsHolder", "Lorg/axonframework/firestarter/FireStarterSettingsHolder;", "(Lorg/axonframework/firestarter/FireStarterSettingsHolder;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "postProcessBeforeInitialization", "", "bean", "beanName", "", "firestarter-spring-starter"})
public final class FireStarterBeanPostProcessor
implements BeanPostProcessor {
    @NotNull
    private final FireStarterSettingsHolder settingsHolder;
    private final Logger logger;

    public FireStarterBeanPostProcessor(@NotNull FireStarterSettingsHolder settingsHolder) {
        Intrinsics.checkNotNullParameter((Object)settingsHolder, (String)"settingsHolder");
        this.settingsHolder = settingsHolder;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Nullable
    public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        if (bean instanceof EventStore) {
            this.logger.info("Decorating EventStore with Axon Framework Firestarter");
            return new FireStarterEventStore((EventStore)bean, this.settingsHolder);
        }
        if (bean instanceof QueryBus) {
            this.logger.info("Decorating QueryBus with Axon Framework Firestarter");
            return new FireStarterQueryBus((QueryBus)bean, this.settingsHolder);
        }
        if (bean instanceof CommandBus) {
            this.logger.info("Decorating CommandBus with Axon Framework Firestarter");
            return new FireStarterCommandBus((CommandBus)bean, this.settingsHolder);
        }
        if (bean instanceof SagaStore) {
            this.logger.info("Decorating SagaRepository with Axon Framework Firestarter");
            return new FireStarterSagaStore((SagaStore)bean, this.settingsHolder);
        }
        if (bean instanceof TokenStore) {
            this.logger.info("Decorating TokenStore with Axon Framework Firestarter");
            return new FireStarterTokenStore((TokenStore)bean, this.settingsHolder);
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }
}

