/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.firestarter;

import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.firestarter.FireStarterSettings;
import org.axonframework.firestarter.FireStarterSettingsHolder;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fire-starter"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\b\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\b\b\u0001\u0010\u000b\u001a\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/axonframework/firestarter/FireStarterController;", "", "settingsHolder", "Lorg/axonframework/firestarter/FireStarterSettingsHolder;", "(Lorg/axonframework/firestarter/FireStarterSettingsHolder;)V", "getConfig", "Lorg/springframework/http/ResponseEntity;", "Lorg/axonframework/firestarter/FireStarterSettings;", "serveFrontend", "", "setConfig", "settings", "firestarter-spring-starter"})
public class FireStarterController {
    @NotNull
    private final FireStarterSettingsHolder settingsHolder;

    public FireStarterController(@NotNull FireStarterSettingsHolder settingsHolder) {
        Intrinsics.checkNotNullParameter((Object)settingsHolder, (String)"settingsHolder");
        this.settingsHolder = settingsHolder;
    }

    @GetMapping(value={"/"}, produces={"text/html"})
    @ResponseBody
    @NotNull
    public String serveFrontend() {
        InputStream stream = ResourceUtils.getURL((String)"classpath:static/fire-starter/index.html").openStream();
        String string = StreamUtils.copyToString((InputStream)stream, (Charset)Charset.defaultCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"copyToString(...)");
        return string;
    }

    @PostMapping(value={"settings"})
    @NotNull
    public ResponseEntity<String> setConfig(@RequestBody @NotNull FireStarterSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settingsHolder.setSettings(settings);
        ResponseEntity responseEntity = ResponseEntity.accepted().build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }

    @GetMapping(value={"settings"}, produces={"application/json"})
    @NotNull
    public ResponseEntity<FireStarterSettings> getConfig() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.settingsHolder.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }
}

