/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonmark.internal.BlockContinueImpl;
import org.commonmark.internal.BlockQuoteParser;
import org.commonmark.internal.BlockStartImpl;
import org.commonmark.internal.DocumentBlockParser;
import org.commonmark.internal.FencedCodeBlockParser;
import org.commonmark.internal.HeadingParser;
import org.commonmark.internal.HtmlBlockParser;
import org.commonmark.internal.IndentedCodeBlockParser;
import org.commonmark.internal.InlineParserContextImpl;
import org.commonmark.internal.LinkReferenceDefinitions;
import org.commonmark.internal.ListBlockParser;
import org.commonmark.internal.ParagraphParser;
import org.commonmark.internal.ThematicBreakParser;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.ListBlock;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.IncludeSourceSpans;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.InlineParserFactory;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockParserFactory;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.parser.delimiter.DelimiterProcessor;

public class DocumentParser
implements ParserState {
    private static final Set<Class<? extends Block>> CORE_FACTORY_TYPES = new LinkedHashSet<Class>(Arrays.asList(BlockQuote.class, Heading.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, ListBlock.class, IndentedCodeBlock.class));
    private static final Map<Class<? extends Block>, BlockParserFactory> NODES_TO_CORE_FACTORIES;
    private SourceLine line;
    private int lineIndex = -1;
    private int index = 0;
    private int column = 0;
    private boolean columnIsInTab;
    private int nextNonSpace = 0;
    private int nextNonSpaceColumn = 0;
    private int indent = 0;
    private boolean blank;
    private final List<BlockParserFactory> blockParserFactories;
    private final InlineParserFactory inlineParserFactory;
    private final List<DelimiterProcessor> delimiterProcessors;
    private final IncludeSourceSpans includeSourceSpans;
    private final DocumentBlockParser documentBlockParser;
    private final LinkReferenceDefinitions definitions = new LinkReferenceDefinitions();
    private final List<OpenBlockParser> openBlockParsers = new ArrayList<OpenBlockParser>();
    private final List<BlockParser> allBlockParsers = new ArrayList<BlockParser>();

    public DocumentParser(List<BlockParserFactory> blockParserFactories, InlineParserFactory inlineParserFactory, List<DelimiterProcessor> delimiterProcessors, IncludeSourceSpans includeSourceSpans) {
        this.blockParserFactories = blockParserFactories;
        this.inlineParserFactory = inlineParserFactory;
        this.delimiterProcessors = delimiterProcessors;
        this.includeSourceSpans = includeSourceSpans;
        this.documentBlockParser = new DocumentBlockParser();
        this.activateBlockParser(new OpenBlockParser(this.documentBlockParser, 0));
    }

    public static Set<Class<? extends Block>> getDefaultBlockParserTypes() {
        return CORE_FACTORY_TYPES;
    }

    public static List<BlockParserFactory> calculateBlockParserFactories(List<BlockParserFactory> customBlockParserFactories, Set<Class<? extends Block>> enabledBlockTypes) {
        ArrayList<BlockParserFactory> list = new ArrayList<BlockParserFactory>();
        list.addAll(customBlockParserFactories);
        for (Class<? extends Block> blockType : enabledBlockTypes) {
            list.add(NODES_TO_CORE_FACTORIES.get(blockType));
        }
        return list;
    }

    public static void checkEnabledBlockTypes(Set<Class<? extends Block>> enabledBlockTypes) {
        for (Class<? extends Block> enabledBlockType : enabledBlockTypes) {
            if (NODES_TO_CORE_FACTORIES.containsKey(enabledBlockType)) continue;
            throw new IllegalArgumentException("Can't enable block type " + enabledBlockType + ", possible options are: " + NODES_TO_CORE_FACTORIES.keySet());
        }
    }

    public Document parse(String input) {
        String line;
        int lineBreak;
        int lineStart = 0;
        while ((lineBreak = Parsing.findLineBreak(input, lineStart)) != -1) {
            line = input.substring(lineStart, lineBreak);
            this.parseLine(line);
            if (lineBreak + 1 < input.length() && input.charAt(lineBreak) == '\r' && input.charAt(lineBreak + 1) == '\n') {
                lineStart = lineBreak + 2;
                continue;
            }
            lineStart = lineBreak + 1;
        }
        if (input.length() > 0 && (lineStart == 0 || lineStart < input.length())) {
            line = input.substring(lineStart);
            this.parseLine(line);
        }
        return this.finalizeAndProcess();
    }

    public Document parse(Reader input) throws IOException {
        String line;
        BufferedReader bufferedReader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        while ((line = bufferedReader.readLine()) != null) {
            this.parseLine(line);
        }
        return this.finalizeAndProcess();
    }

    @Override
    public SourceLine getLine() {
        return this.line;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getNextNonSpaceIndex() {
        return this.nextNonSpace;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public boolean isBlank() {
        return this.blank;
    }

    @Override
    public BlockParser getActiveBlockParser() {
        return this.openBlockParsers.get((int)(this.openBlockParsers.size() - 1)).blockParser;
    }

    private void parseLine(CharSequence ln) {
        boolean tryBlockStarts;
        this.setLine(ln);
        int matches = 1;
        for (int i = 1; i < this.openBlockParsers.size(); ++i) {
            OpenBlockParser openBlockParser = this.openBlockParsers.get(i);
            BlockParser blockParser = openBlockParser.blockParser;
            this.findNextNonSpace();
            BlockContinue result = blockParser.tryContinue(this);
            if (!(result instanceof BlockContinueImpl)) break;
            BlockContinueImpl blockContinue = (BlockContinueImpl)result;
            openBlockParser.sourceIndex = this.getIndex();
            if (blockContinue.isFinalize()) {
                this.addSourceSpans();
                this.closeBlockParsers(this.openBlockParsers.size() - i);
                return;
            }
            if (blockContinue.getNewIndex() != -1) {
                this.setNewIndex(blockContinue.getNewIndex());
            } else if (blockContinue.getNewColumn() != -1) {
                this.setNewColumn(blockContinue.getNewColumn());
            }
            ++matches;
        }
        int unmatchedBlocks = this.openBlockParsers.size() - matches;
        BlockParser blockParser = this.openBlockParsers.get((int)(matches - 1)).blockParser;
        boolean startedNewBlock = false;
        int lastIndex = this.index;
        boolean bl = tryBlockStarts = blockParser.getBlock() instanceof Paragraph || blockParser.isContainer();
        while (tryBlockStarts) {
            lastIndex = this.index;
            this.findNextNonSpace();
            if (this.isBlank() || this.indent < Parsing.CODE_BLOCK_INDENT && Parsing.isLetter(this.line.getContent(), this.nextNonSpace)) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            BlockStartImpl blockStart = this.findBlockStart(blockParser);
            if (blockStart == null) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            startedNewBlock = true;
            int sourceIndex = this.getIndex();
            if (unmatchedBlocks > 0) {
                this.closeBlockParsers(unmatchedBlocks);
                unmatchedBlocks = 0;
            }
            if (blockStart.getNewIndex() != -1) {
                this.setNewIndex(blockStart.getNewIndex());
            } else if (blockStart.getNewColumn() != -1) {
                this.setNewColumn(blockStart.getNewColumn());
            }
            List<SourceSpan> replacedSourceSpans = null;
            if (blockStart.isReplaceActiveBlockParser()) {
                Block replacedBlock = this.prepareActiveBlockParserForReplacement();
                replacedSourceSpans = replacedBlock.getSourceSpans();
            }
            for (BlockParser newBlockParser : blockStart.getBlockParsers()) {
                this.addChild(new OpenBlockParser(newBlockParser, sourceIndex));
                if (replacedSourceSpans != null) {
                    newBlockParser.getBlock().setSourceSpans(replacedSourceSpans);
                }
                blockParser = newBlockParser;
                tryBlockStarts = newBlockParser.isContainer();
            }
        }
        if (!startedNewBlock && !this.isBlank() && this.getActiveBlockParser().canHaveLazyContinuationLines()) {
            this.openBlockParsers.get((int)(this.openBlockParsers.size() - 1)).sourceIndex = lastIndex;
            this.addLine();
        } else {
            if (unmatchedBlocks > 0) {
                this.closeBlockParsers(unmatchedBlocks);
            }
            if (!blockParser.isContainer()) {
                this.addLine();
            } else if (!this.isBlank()) {
                ParagraphParser paragraphParser = new ParagraphParser();
                this.addChild(new OpenBlockParser(paragraphParser, lastIndex));
                this.addLine();
            } else {
                this.addSourceSpans();
            }
        }
    }

    private void setLine(CharSequence ln) {
        ++this.lineIndex;
        this.index = 0;
        this.column = 0;
        this.columnIsInTab = false;
        CharSequence lineContent = Parsing.prepareLine(ln);
        SourceSpan sourceSpan = null;
        if (this.includeSourceSpans != IncludeSourceSpans.NONE) {
            sourceSpan = SourceSpan.of(this.lineIndex, 0, lineContent.length());
        }
        this.line = SourceLine.of(lineContent, sourceSpan);
    }

    private void findNextNonSpace() {
        int i = this.index;
        int cols = this.column;
        this.blank = true;
        int length = this.line.getContent().length();
        block4: while (i < length) {
            char c = this.line.getContent().charAt(i);
            switch (c) {
                case ' ': {
                    ++i;
                    ++cols;
                    continue block4;
                }
                case '\t': {
                    ++i;
                    cols += 4 - cols % 4;
                    continue block4;
                }
            }
            this.blank = false;
            break;
        }
        this.nextNonSpace = i;
        this.nextNonSpaceColumn = cols;
        this.indent = this.nextNonSpaceColumn - this.column;
    }

    private void setNewIndex(int newIndex) {
        if (newIndex >= this.nextNonSpace) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        int length = this.line.getContent().length();
        while (this.index < newIndex && this.index != length) {
            this.advance();
        }
        this.columnIsInTab = false;
    }

    private void setNewColumn(int newColumn) {
        if (newColumn >= this.nextNonSpaceColumn) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        int length = this.line.getContent().length();
        while (this.column < newColumn && this.index != length) {
            this.advance();
        }
        if (this.column > newColumn) {
            --this.index;
            this.column = newColumn;
            this.columnIsInTab = true;
        } else {
            this.columnIsInTab = false;
        }
    }

    private void advance() {
        char c = this.line.getContent().charAt(this.index);
        ++this.index;
        this.column = c == '\t' ? (this.column += Parsing.columnsToNextTabStop(this.column)) : ++this.column;
    }

    private void addLine() {
        CharSequence content;
        if (this.columnIsInTab) {
            int afterTab = this.index + 1;
            CharSequence rest = this.line.getContent().subSequence(afterTab, this.line.getContent().length());
            int spaces = Parsing.columnsToNextTabStop(this.column);
            StringBuilder sb = new StringBuilder(spaces + rest.length());
            for (int i = 0; i < spaces; ++i) {
                sb.append(' ');
            }
            sb.append(rest);
            content = sb.toString();
        } else {
            content = this.index == 0 ? this.line.getContent() : this.line.getContent().subSequence(this.index, this.line.getContent().length());
        }
        SourceSpan sourceSpan = null;
        if (this.includeSourceSpans == IncludeSourceSpans.BLOCKS_AND_INLINES) {
            sourceSpan = SourceSpan.of(this.lineIndex, this.index, content.length());
        }
        this.getActiveBlockParser().addLine(SourceLine.of(content, sourceSpan));
        this.addSourceSpans();
    }

    private void addSourceSpans() {
        if (this.includeSourceSpans != IncludeSourceSpans.NONE) {
            for (int i = 1; i < this.openBlockParsers.size(); ++i) {
                OpenBlockParser openBlockParser = this.openBlockParsers.get(i);
                int blockIndex = openBlockParser.sourceIndex;
                int length = this.line.getContent().length() - blockIndex;
                if (length == 0) continue;
                openBlockParser.blockParser.addSourceSpan(SourceSpan.of(this.lineIndex, blockIndex, length));
            }
        }
    }

    private BlockStartImpl findBlockStart(BlockParser blockParser) {
        MatchedBlockParserImpl matchedBlockParser = new MatchedBlockParserImpl(blockParser);
        for (BlockParserFactory blockParserFactory : this.blockParserFactories) {
            BlockStart result = blockParserFactory.tryStart(this, matchedBlockParser);
            if (!(result instanceof BlockStartImpl)) continue;
            return (BlockStartImpl)result;
        }
        return null;
    }

    private void finalize(BlockParser blockParser) {
        if (blockParser instanceof ParagraphParser) {
            this.addDefinitionsFrom((ParagraphParser)blockParser);
        }
        blockParser.closeBlock();
    }

    private void addDefinitionsFrom(ParagraphParser paragraphParser) {
        for (LinkReferenceDefinition definition : paragraphParser.getDefinitions()) {
            paragraphParser.getBlock().insertBefore(definition);
            this.definitions.add(definition);
        }
    }

    private void processInlines() {
        InlineParserContextImpl context = new InlineParserContextImpl(this.delimiterProcessors, this.definitions);
        InlineParser inlineParser = this.inlineParserFactory.create(context);
        for (BlockParser blockParser : this.allBlockParsers) {
            blockParser.parseInlines(inlineParser);
        }
    }

    private void addChild(OpenBlockParser openBlockParser) {
        while (!this.getActiveBlockParser().canContain(openBlockParser.blockParser.getBlock())) {
            this.closeBlockParsers(1);
        }
        this.getActiveBlockParser().getBlock().appendChild(openBlockParser.blockParser.getBlock());
        this.activateBlockParser(openBlockParser);
    }

    private void activateBlockParser(OpenBlockParser openBlockParser) {
        this.openBlockParsers.add(openBlockParser);
    }

    private OpenBlockParser deactivateBlockParser() {
        return this.openBlockParsers.remove(this.openBlockParsers.size() - 1);
    }

    private Block prepareActiveBlockParserForReplacement() {
        BlockParser old = this.deactivateBlockParser().blockParser;
        if (old instanceof ParagraphParser) {
            ParagraphParser paragraphParser = (ParagraphParser)old;
            this.addDefinitionsFrom(paragraphParser);
        }
        old.closeBlock();
        old.getBlock().unlink();
        return old.getBlock();
    }

    private Document finalizeAndProcess() {
        this.closeBlockParsers(this.openBlockParsers.size());
        this.processInlines();
        return this.documentBlockParser.getBlock();
    }

    private void closeBlockParsers(int count) {
        for (int i = 0; i < count; ++i) {
            BlockParser blockParser = this.deactivateBlockParser().blockParser;
            this.finalize(blockParser);
            this.allBlockParsers.add(blockParser);
        }
    }

    static {
        HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory> map = new HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory>();
        map.put(BlockQuote.class, new BlockQuoteParser.Factory());
        map.put(Heading.class, new HeadingParser.Factory());
        map.put(FencedCodeBlock.class, new FencedCodeBlockParser.Factory());
        map.put(HtmlBlock.class, new HtmlBlockParser.Factory());
        map.put(ThematicBreak.class, new ThematicBreakParser.Factory());
        map.put(ListBlock.class, new ListBlockParser.Factory());
        map.put(IndentedCodeBlock.class, new IndentedCodeBlockParser.Factory());
        NODES_TO_CORE_FACTORIES = Collections.unmodifiableMap(map);
    }

    private static class OpenBlockParser {
        private final BlockParser blockParser;
        private int sourceIndex;

        OpenBlockParser(BlockParser blockParser, int sourceIndex) {
            this.blockParser = blockParser;
            this.sourceIndex = sourceIndex;
        }
    }

    private static class MatchedBlockParserImpl
    implements MatchedBlockParser {
        private final BlockParser matchedBlockParser;

        public MatchedBlockParserImpl(BlockParser matchedBlockParser) {
            this.matchedBlockParser = matchedBlockParser;
        }

        @Override
        public BlockParser getMatchedBlockParser() {
            return this.matchedBlockParser;
        }

        @Override
        public SourceLines getParagraphLines() {
            if (this.matchedBlockParser instanceof ParagraphParser) {
                ParagraphParser paragraphParser = (ParagraphParser)this.matchedBlockParser;
                return paragraphParser.getParagraphLines();
            }
            return SourceLines.empty();
        }
    }
}

