/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.utils.Disposable;

public abstract class Shape
implements Disposable {
    protected long addr;
    private static final float[] verts = new float[4];

    public abstract Type getType();

    public float getRadius() {
        return this.jniGetRadius(this.addr);
    }

    private native float jniGetRadius(long var1);

    public void setRadius(float radius) {
        this.jniSetRadius(this.addr, radius);
    }

    private native void jniSetRadius(long var1, float var3);

    public void dispose() {
        this.jniDispose(this.addr);
    }

    private native void jniDispose(long var1);

    protected static native int jniGetType(long var0);

    public int getChildCount() {
        return this.jniGetChildCount(this.addr);
    }

    private native int jniGetChildCount(long var1);

    public boolean testPoint(Transform transform, Vector2 point) {
        return this.jniTestPoint(this.addr, transform.vals[0], transform.vals[1], transform.vals[2], transform.vals[3], point.x, point.y);
    }

    public native boolean jniTestPoint(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    public void computeAABB(Vector2 lowerBound, Vector2 upperBound, Transform transform, int childIndex) {
        this.jniComputeAABB(this.addr, verts, transform.vals[0], transform.vals[1], transform.vals[2], transform.vals[3], childIndex);
        lowerBound.x = verts[0];
        lowerBound.y = verts[1];
        upperBound.x = verts[2];
        upperBound.y = verts[3];
    }

    private native void jniComputeAABB(long var1, float[] var3, float var4, float var5, float var6, float var7, int var8);

    public static boolean testOverlap(Shape shapeA, int indexA, Shape shapeB, int indexB, Transform transformA, Transform transformB) {
        return Shape.jniTestOverlap(shapeA.addr, indexA, shapeB.addr, indexB, transformA.vals[0], transformA.vals[1], transformA.vals[2], transformA.vals[3], transformB.vals[0], transformB.vals[1], transformB.vals[2], transformB.vals[3]);
    }

    private static native boolean jniTestOverlap(long var0, int var2, long var3, int var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13);

    public static enum Type {
        Circle,
        Edge,
        Polygon,
        Chain;

    }
}

