/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d.rope;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.JniUtil;
import com.badlogic.gdx.physics.box2d.rope.RopeDef;
import com.badlogic.gdx.physics.box2d.rope.RopeTuning;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;

public class Rope
implements Disposable {
    protected long addr;
    private static DrawData drawData;

    protected Rope(long addr) {
        this.addr = addr;
    }

    public Rope() {
        this(Rope.newRope());
    }

    private static native long newRope();

    public void dispose() {
        this.jniDispose(this.addr);
    }

    private native void jniDispose(long var1);

    public void create(RopeDef def) {
        RopeTuning tuning = def.tuning;
        float[] verts = JniUtil.arrayOfVec2IntoFloat(def.vertices);
        this.jniCreate(this.addr, verts, def.masses, def.masses.length, def.gravity.x, def.gravity.y, tuning.stretchingModel.value, tuning.bendingModel.value, tuning.damping, tuning.stretchStiffness, tuning.stretchHertz, tuning.stretchDamping, tuning.bendStiffness, tuning.bendHertz, tuning.bendDamping, tuning.isometric, tuning.fixedEffectiveMass, tuning.warmStart);
    }

    private native void jniCreate(long var1, float[] var3, float[] var4, int var5, float var6, float var7, int var8, int var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, boolean var17, boolean var18, boolean var19);

    public void step(float timeStep, int iterations, Vector2 position) {
        this.jniStep(this.addr, timeStep, iterations, position.x, position.y);
    }

    private native void jniStep(long var1, float var3, int var4, float var5, float var6);

    public void reset(Vector2 position) {
        this.jniReset(this.addr, position.x, position.y);
    }

    private native void jniReset(long var1, float var3, float var4);

    private native int jniGetCount(long var1);

    private native void jniGetPS(long var1, float[] var3);

    private native void jniGetInvMasses(long var1, float[] var3);

    public DrawData getDrawData() {
        int count;
        if (drawData == null) {
            drawData = new DrawData();
        }
        Rope.drawData.verticesFlat.clear();
        Rope.drawData.invMasses.clear();
        Rope.drawData.count = count = this.jniGetCount(this.addr);
        Rope.drawData.verticesFlat.setSize(count * 2);
        Rope.drawData.invMasses.setSize(count);
        this.jniGetPS(this.addr, Rope.drawData.verticesFlat.items);
        this.jniGetInvMasses(this.addr, Rope.drawData.invMasses.items);
        return drawData;
    }

    public static class DrawData {
        private final Vector2 tmp = new Vector2();
        public final FloatArray verticesFlat = new FloatArray();
        public final FloatArray invMasses = new FloatArray();
        public int count;

        public Vector2 pointAt(int i) {
            this.tmp.x = this.verticesFlat.get(i * 2);
            this.tmp.y = this.verticesFlat.get(i * 2 + 1);
            return this.tmp;
        }
    }
}

