/*
 * Decompiled with CFR 0.152.
 */
package org.aya.guest0x0.cubical;

import java.io.Serializable;
import java.util.function.Function;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.guest0x0.cubical.Restr;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Partial<Term extends Restr.TermLike<Term>>
extends Serializable {
    @NotNull
    public Restr<Term> restr();

    @NotNull
    public Partial<Term> map(@NotNull Function<Term, Term> var1);

    @Contract(value="_->new")
    @NotNull
    public <To extends Restr.TermLike<To>> Partial<To> fmap(@NotNull Function<Term, To> var1);

    @NotNull
    public SeqView<Term> termsView();

    public record Const<Term extends Restr.TermLike<Term>>(@NotNull Term u) implements Partial<Term>
    {
        @Override
        @NotNull
        public Restr<Term> restr() {
            return new Restr.Const(true);
        }

        @Override
        @NotNull
        public Const<Term> map(@NotNull Function<Term, Term> mapper) {
            Restr.TermLike v = (Restr.TermLike)mapper.apply(this.u);
            if (v == this.u) {
                return this;
            }
            return new Const<Restr.TermLike>(v);
        }

        @Override
        @NotNull
        public <To extends Restr.TermLike<To>> Const<To> fmap(@NotNull Function<Term, To> mapper) {
            return new Const<Restr.TermLike>((Restr.TermLike)mapper.apply(this.u));
        }

        @Override
        @NotNull
        public SeqView<Term> termsView() {
            return SeqView.of(this.u);
        }
    }

    public record Split<Term extends Restr.TermLike<Term>>(@NotNull ImmutableSeq<Restr.Side<Term>> clauses) implements Partial<Term>
    {
        @Override
        @NotNull
        public Restr<Term> restr() {
            return new Restr.Disj(this.clauses.map(Restr.Side::cof));
        }

        @Override
        @NotNull
        public Split<Term> map(@NotNull Function<Term, Term> mapper) {
            ImmutableSeq cl = this.clauses.map(c -> c.rename(mapper));
            if (cl.sameElements(this.clauses, true)) {
                return this;
            }
            return new Split<Term>(cl);
        }

        @Override
        @NotNull
        public <To extends Restr.TermLike<To>> Split<To> fmap(@NotNull Function<Term, To> mapper) {
            return new Split<Term>(this.clauses.map(c -> c.fmap(mapper)));
        }

        @Override
        @NotNull
        public SeqView<Term> termsView() {
            return this.clauses.view().flatMap(cl -> cl.cof().view().appended(cl.u()));
        }
    }
}

