/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.error;

import org.aya.pretty.error.PrettyErrorConfig;
import org.aya.pretty.error.Span;
import org.jetbrains.annotations.NotNull;

public record RangeSpan(@NotNull String input, int start, int end) implements Span
{
    @NotNull
    public static RangeSpan from(@NotNull String input, int start, int end) {
        if (start < 0 || end < 0 || end >= input.length() || end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new RangeSpan(input, start, end);
    }

    private boolean isVariationSelector(int code) {
        return code >= 65024 && code <= 65039;
    }

    @Override
    @NotNull
    public Span.Data normalize(PrettyErrorConfig config) {
        String input = this.input();
        int line = 1;
        int col = 0;
        int pos = 0;
        int startLine = -1;
        int startCol = -1;
        int endLine = -1;
        int endCol = -1;
        int tabWidth = config.tabWidth();
        int[] codePoints = input.codePoints().toArray();
        while (pos < codePoints.length) {
            int c = codePoints[pos];
            int oldPos = pos++;
            int oldCol = col;
            if (c == 10) {
                ++line;
                col = 0;
            } else {
                col = c == 9 ? (col += tabWidth) : (this.isVariationSelector(c) ? (col += 0) : (c > 128 && (Character.isUnicodeIdentifierStart(c) || Character.isUnicodeIdentifierPart(c) || Character.isSupplementaryCodePoint(c)) ? (col += 2) : ++col));
            }
            if (oldPos == this.start) {
                startLine = line;
                startCol = oldCol;
            }
            if (oldPos != this.end) continue;
            endLine = line;
            endCol = oldCol;
        }
        return new Span.Data(startLine, startCol, endLine, endCol);
    }

    @Override
    public String toString() {
        return this.input.substring(this.start, this.end + 1);
    }
}

