/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.html;

import org.aya.pretty.backend.html.Html5Stylist;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.LinkId;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class DocHtmlPrinter
extends StringPrinter<Config> {
    @Language(value="HTML")
    @NotNull
    private static final String HEAD = "<!DOCTYPE html><html lang=\"en\"><head>\n<title>Aya file</title>\n<meta charset=\"UTF-8\" />\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n<script>\nvar highlight = function (on) {\n  return function () {\n    var links = document.getElementsByTagName('a');\n    for (var i = 0; i < links.length; i++) {\n      var that = links[i];\n      if (this.href != that.href) continue;\n      if (on) that.classList.add(\"hover-highlight\");\n      else that.classList.remove(\"hover-highlight\");\n    }\n  }\n};\nwindow.onload = function () {\n  var links = document.getElementsByTagName('a');\n  for (var i = 0; i < links.length; i++) {\n    var link = links[i];\n    if (!link.hasAttribute(\"href\")) continue;\n    link.onmouseover = highlight(true);\n    link.onmouseout = highlight(false);\n  }\n};\n</script>\n<style>\n.Aya a { text-decoration: none; color: black; }\n.Aya a[href]:hover { background-color: #B4EEB4; }\n.Aya [href].hover-highlight { background-color: #B4EEB4; }\n</style>\n</head><body>\n<pre class=\"Aya\">\n";

    @Override
    protected void renderHeader(@NotNull Cursor cursor) {
        if (((Config)this.config).withHeader) {
            cursor.invisibleContent(HEAD);
        } else {
            cursor.invisibleContent("<pre class=\"Aya\">");
        }
    }

    @Override
    protected void renderFooter(@NotNull Cursor cursor) {
        cursor.invisibleContent("</pre>");
        if (((Config)this.config).withHeader) {
            cursor.invisibleContent("</body></html>");
        }
    }

    @Override
    protected void renderHyperLinked(@NotNull Cursor cursor,  @NotNull Doc.HyperLinked text) {
        LinkId link = text.link();
        cursor.invisibleContent("<a ");
        if (text.id() != null) {
            cursor.invisibleContent("id=\"" + text.id() + "\" ");
        }
        cursor.invisibleContent("href=\"");
        cursor.invisibleContent(link.id());
        cursor.invisibleContent("\">");
        this.renderDoc(cursor, text.doc());
        cursor.invisibleContent("</a>");
    }

    @Override
    protected void renderHardLineBreak(@NotNull Cursor cursor) {
        cursor.lineBreakWith("<br>");
    }

    public static class Config
    extends StringPrinterConfig {
        public final boolean withHeader;

        public Config(boolean withHeader) {
            super(new Html5Stylist(AyaColorScheme.EMACS, AyaStyleFamily.DEFAULT), -1, true);
            this.withHeader = withHeader;
        }
    }
}

