/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.Map;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.printer.Printer;
import org.aya.pretty.printer.PrinterConfig;
import org.jetbrains.annotations.NotNull;

public class StringPrinter<StringConfig extends StringPrinterConfig>
implements Printer<String, StringConfig>,
Cursor.CursorAPI {
    protected StringConfig config;
    @NotNull
    private static final Map<String, String> unicodeMapping = Map.ofEntries((Tuple2[])new Tuple2[]{Tuple.of((Object)"Pi", (Object)"\u03a0"), Tuple.of((Object)"Sig", (Object)"\u03a3"), Tuple.of((Object)"Sigma", (Object)"\u03a3"), Tuple.of((Object)"\\", (Object)"\u03bb"), Tuple.of((Object)"/\\", (Object)"\u2227"), Tuple.of((Object)"\\/", (Object)"\u2228"), Tuple.of((Object)"=>", (Object)"\u21d2"), Tuple.of((Object)"ulift", (Object)"\u2191"), Tuple.of((Object)"->", (Object)"\u2192"), Tuple.of((Object)"_|_", (Object)"\u22a5"), Tuple.of((Object)"top", (Object)"\u22a4"), Tuple.of((Object)"(|", (Object)"\u2987"), Tuple.of((Object)"|)", (Object)"\u2988"), Tuple.of((Object)"{|", (Object)"\u2983"), Tuple.of((Object)"|}", (Object)"\u2984"), Tuple.of((Object)"[|", (Object)"\u27e6"), Tuple.of((Object)"|]", (Object)"\u27e7")});

    @Override
    @NotNull
    public String makeIndent(int indent) {
        return " ".repeat(indent);
    }

    @Override
    @NotNull
    public String render(@NotNull StringConfig config, @NotNull Doc doc) {
        this.config = config;
        Cursor cursor = new Cursor(this);
        this.renderHeader(cursor);
        this.renderDoc(cursor, doc);
        this.renderFooter(cursor);
        return cursor.result().toString();
    }

    private int lineRemaining(@NotNull Cursor cursor) {
        int pw = ((PrinterConfig.Basic)this.config).getPageWidth();
        return pw == -1 ? pw : pw - cursor.getCursor();
    }

    protected int predictWidth(@NotNull Cursor cursor, @NotNull Doc doc) {
        Doc doc2 = doc;
        Objects.requireNonNull(doc2);
        Doc doc3 = doc2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Doc.Empty.class, Doc.PlainText.class, Doc.SpecialSymbol.class, Doc.HyperLinked.class, Doc.Styled.class, Doc.Line.class, Doc.FlatAlt.class, Doc.Cat.class, Doc.Nest.class, Doc.Union.class, Doc.Column.class, Doc.Nesting.class, Doc.PageWidth.class}, (Object)doc3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Doc.Empty d = (Doc.Empty)doc3;
                yield 0;
            }
            case 1 -> {
                Doc.PlainText text = (Doc.PlainText)doc3;
                yield text.text().length();
            }
            case 2 -> {
                Doc.SpecialSymbol symbol = (Doc.SpecialSymbol)doc3;
                yield symbol.text().length();
            }
            case 3 -> {
                Doc.HyperLinked text = (Doc.HyperLinked)doc3;
                yield this.predictWidth(cursor, text.doc());
            }
            case 4 -> {
                Doc.Styled styled = (Doc.Styled)doc3;
                yield this.predictWidth(cursor, styled.doc());
            }
            case 5 -> {
                Doc.Line d = (Doc.Line)doc3;
                yield 0;
            }
            case 6 -> {
                Doc.FlatAlt alt = (Doc.FlatAlt)doc3;
                yield this.predictWidth(cursor, alt.defaultDoc());
            }
            case 7 -> {
                Doc.Cat cat = (Doc.Cat)doc3;
                yield (Integer)cat.inner().view().map(inner -> this.predictWidth(cursor, (Doc)inner)).reduce(Integer::sum);
            }
            case 8 -> {
                Doc.Nest nest = (Doc.Nest)doc3;
                yield this.predictWidth(cursor, nest.doc()) + nest.indent();
            }
            case 9 -> {
                Doc.Union union = (Doc.Union)doc3;
                yield this.predictWidth(cursor, union.longerOne());
            }
            case 10 -> {
                Doc.Column column = (Doc.Column)doc3;
                yield this.predictWidth(cursor, column.docBuilder().apply(cursor.getCursor()));
            }
            case 11 -> {
                Doc.Nesting nesting = (Doc.Nesting)doc3;
                yield this.predictWidth(cursor, nesting.docBuilder().apply(cursor.getNestLevel()));
            }
            case 12 -> {
                Doc.PageWidth pageWidth = (Doc.PageWidth)doc3;
                yield this.predictWidth(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()));
            }
        };
    }

    @NotNull
    protected Doc fitsBetter(@NotNull Cursor cursor, @NotNull Doc a, @NotNull Doc b) {
        if (cursor.isAtLineStart()) {
            return a;
        }
        int lineRem = this.lineRemaining(cursor);
        return lineRem == -1 || this.predictWidth(cursor, a) <= lineRem ? a : b;
    }

    protected void renderHeader(@NotNull Cursor cursor) {
    }

    protected void renderFooter(@NotNull Cursor cursor) {
    }

    protected void renderDoc(@NotNull Cursor cursor, @NotNull Doc doc) {
        Doc doc2 = doc;
        Objects.requireNonNull(doc2);
        Doc doc3 = doc2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Doc.PlainText.class, Doc.SpecialSymbol.class, Doc.HyperLinked.class, Doc.Styled.class, Doc.Line.class, Doc.FlatAlt.class, Doc.Cat.class, Doc.Nest.class, Doc.Union.class, Doc.Column.class, Doc.Nesting.class, Doc.PageWidth.class}, (Object)doc3, n)) {
            case 0: {
                Doc.PlainText text = (Doc.PlainText)doc3;
                this.renderPlainText(cursor, text.text());
                break;
            }
            case 1: {
                Doc.SpecialSymbol symbol = (Doc.SpecialSymbol)doc3;
                this.renderSpecialSymbol(cursor, symbol.text());
                break;
            }
            case 2: {
                Doc.HyperLinked text = (Doc.HyperLinked)doc3;
                this.renderHyperLinked(cursor, text);
                break;
            }
            case 3: {
                Doc.Styled styled = (Doc.Styled)doc3;
                this.renderStyled(cursor, styled);
                break;
            }
            case 4: {
                Doc.Line d = (Doc.Line)doc3;
                this.renderHardLineBreak(cursor);
                break;
            }
            case 5: {
                Doc.FlatAlt alt = (Doc.FlatAlt)doc3;
                this.renderFlatAlt(cursor, alt);
                break;
            }
            case 6: {
                Doc.Cat cat = (Doc.Cat)doc3;
                cat.inner().forEach(inner -> this.renderDoc(cursor, (Doc)inner));
                break;
            }
            case 7: {
                Doc.Nest nest = (Doc.Nest)doc3;
                this.renderNest(cursor, nest);
                break;
            }
            case 8: {
                Doc.Union union = (Doc.Union)doc3;
                this.renderUnionDoc(cursor, union);
                break;
            }
            case 9: {
                Doc.Column column = (Doc.Column)doc3;
                this.renderDoc(cursor, column.docBuilder().apply(cursor.getCursor()));
                break;
            }
            case 10: {
                Doc.Nesting nesting = (Doc.Nesting)doc3;
                this.renderDoc(cursor, nesting.docBuilder().apply(cursor.getNestLevel()));
                break;
            }
            case 11: {
                Doc.PageWidth pageWidth = (Doc.PageWidth)doc3;
                this.renderDoc(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()));
                break;
            }
        }
    }

    protected void renderSpecialSymbol(@NotNull Cursor cursor, @NotNull String text) {
        if (((StringPrinterConfig)this.config).unicode) {
            for (String k : unicodeMapping.keysView()) {
                if (!text.trim().equals(k)) continue;
                cursor.visibleContent(text.replace(k, (CharSequence)unicodeMapping.get((Object)k)));
                return;
            }
        }
        this.renderPlainText(cursor, text);
    }

    protected void renderNest(@NotNull Cursor cursor, @NotNull Doc.Nest nest) {
        cursor.nested(nest.indent(), () -> this.renderDoc(cursor, nest.doc()));
    }

    protected void renderUnionDoc(@NotNull Cursor cursor, @NotNull Doc.Union union) {
        this.renderDoc(cursor, this.fitsBetter(cursor, union.shorterOne(), union.longerOne()));
    }

    protected void renderFlatAlt(@NotNull Cursor cursor, @NotNull Doc.FlatAlt alt) {
        this.renderDoc(cursor, this.fitsBetter(cursor, alt.defaultDoc(), alt.preferWhenFlatten()));
    }

    protected void renderHyperLinked(@NotNull Cursor cursor, @NotNull Doc.HyperLinked text) {
        this.renderDoc(cursor, text.doc());
    }

    protected void renderStyled(@NotNull Cursor cursor, @NotNull Doc.Styled styled) {
        StringStylist stylist = ((StringPrinterConfig)this.config).getStylist();
        stylist.format(styled.styles(), cursor, () -> this.renderDoc(cursor, styled.doc()));
    }

    protected void renderPlainText(@NotNull Cursor cursor, @NotNull String content) {
        cursor.visibleContent(content);
    }

    protected void renderHardLineBreak(@NotNull Cursor cursor) {
        cursor.lineBreakWith("\n");
    }
}

