/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl;

import java.util.function.Function;
import kala.control.Try;
import org.aya.repl.ReplCompleters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jline.reader.Completer;

public interface CommandArg {
    @NotNull
    public static final CommandArg STRING = CommandArg.from(String.class, null, Function.identity());
    @NotNull
    public static final CommandArg STRICT_INT = CommandArg.from(Integer.class, null, input -> (Integer)Try.of(() -> Integer.parseInt(input)).getOrThrow(IllegalArgumentException::new));
    @NotNull
    public static final CommandArg STRICT_BOOLEAN = CommandArg.from(Boolean.class, ReplCompleters.BOOL, s -> {
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equalsIgnoreCase("yes")) {
            return true;
        }
        if (s.equalsIgnoreCase("no")) {
            return false;
        }
        throw new IllegalArgumentException("not an boolean value");
    });

    @NotNull
    public Class<?> type();

    @NotNull
    public Object parse(@NotNull String var1) throws IllegalArgumentException;

    @Nullable
    public Completer completer();

    public boolean shellLike();

    private static <R> CommandArg from(@NotNull Class<? extends R> type, boolean shellLike, @Nullable Completer completer, @NotNull Function<String, R> f) {
        return new CommandArgImpl<R>(type, completer, shellLike, f);
    }

    public static <R> CommandArg from(@NotNull Class<? extends R> type, @Nullable Completer completer, @NotNull Function<String, R> f) {
        return CommandArg.from(type, false, completer, f);
    }

    public static <R> CommandArg shellLike(@NotNull Class<? extends R> type, @Nullable Completer completer, @NotNull Function<String, R> f) {
        return CommandArg.from(type, true, completer, f);
    }

    public static <T extends Enum<T>> CommandArg fromEnum(@NotNull Class<T> enumClass) {
        return CommandArg.from(enumClass, false, new ReplCompleters.EnumCompleter<T>(enumClass), input -> Enum.valueOf(enumClass, input));
    }

    public record CommandArgImpl<R>(@NotNull Class<? extends R> type, @Nullable Completer completer, boolean shellLike, @NotNull Function<String, R> f) implements CommandArg
    {
        @Override
        @NotNull
        public Object parse(@NotNull String input) throws IllegalArgumentException {
            return this.f.apply(input);
        }
    }
}

