/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.control.Try;
import kala.tuple.Tuple;
import org.aya.repl.Command;
import org.aya.repl.CommandArg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager {
    @NotNull
    public final @NotNull ImmutableSeq<@NotNull CommandGen> cmd;
    @NotNull
    public final ImmutableMap<Class<?>, CommandArg> argFactory;
    @NotNull
    private final Class<?> replClass;

    public CommandManager(@NotNull Class<?> replClass, @NotNull ImmutableSeq<CommandArg> argFactory, @NotNull ImmutableSeq<Command> commands) {
        this.replClass = replClass;
        this.argFactory = argFactory.view().map(c -> Tuple.of(c.type(), (Object)c)).toImmutableMap();
        this.cmd = commands.map(this::genCommand);
    }

    @NotNull
    private CommandGen genCommand(@NotNull Command c) {
        Optional<Method> entry = Arrays.stream(c.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Command.Entry.class)).findFirst();
        if (entry.isEmpty()) {
            throw new IllegalArgumentException("no entry found in " + c.getClass());
        }
        try {
            Method method2 = entry.get();
            method2.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflect(method2);
            List<Class<?>> param = handle.type().parameterList();
            if (param.size() < 2) {
                throw new IllegalArgumentException("entry method must at least have 1 parameters (the `REPL` instance)");
            }
            if (param.get(1) != this.replClass) {
                throw new IllegalArgumentException("entry method must have `Repl` as first parameter");
            }
            if (param.size() == 2) {
                return new CommandGen(c, handle, null);
            }
            Option factory = this.argFactory.getOption(param.get(2));
            if (factory.isEmpty()) {
                throw new IllegalArgumentException("no argument factory found for " + param.get(2));
            }
            return new CommandGen(c, handle, (CommandArg)factory.get());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to unreflect entry for: " + c.names(), e);
        }
    }

    @NotNull
    public Clue parse(@NotNull String text) {
        String[] split = text.split(" +", 2);
        String name = split[0];
        String argument = split.length > 1 ? split[1] : "";
        return new Clue(name, (ImmutableSeq<CommandGen>)this.cmd.filter(c -> c.owner.names().anyMatch(n -> n.startsWith(name))), argument);
    }

    public record CommandGen(@NotNull Command owner, @NotNull MethodHandle entry, @Nullable CommandArg argFactory) {
        public Command.Result invoke(@NotNull Object repl, @NotNull String argument) throws Throwable {
            if (this.argFactory != null) {
                return this.entry.invoke(this.owner, repl, Try.of(() -> this.argFactory.parse(argument)).getOrNull());
            }
            return this.entry.invoke(this.owner, repl);
        }
    }

    public record Clue(@NotNull String name, @NotNull ImmutableSeq<CommandGen> command, @NotNull String argument) {
        public Command.Result run(@NotNull Object repl) throws Throwable {
            return switch (this.command.size()) {
                case 1 -> ((CommandGen)this.command.first()).invoke(repl, this.argument);
                case 0 -> Command.Result.err("Command `" + this.name + "` not found", true);
                default -> Command.Result.err(this.command.view().flatMap(s -> s.owner.names()).joinToString((CharSequence)"`, `", (CharSequence)"Ambiguous command name (`", (CharSequence)"`), please be more accurate", s -> s), true);
            };
        }
    }
}

