/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.aya.pretty.doc.Doc;
import org.aya.repl.Command;
import org.aya.repl.CommandManager;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;

public interface Repl {
    public void println(@NotNull String var1);

    public void errPrintln(@NotNull String var1);

    @NotNull
    public String readLine(@NotNull String var1) throws EndOfFileException, UserInterruptException;

    @NotNull
    public Command.Output eval(@NotNull String var1);

    default public void printResult(@NotNull Command.Output output) {
        if (output.stdout().isNotEmpty()) {
            this.println(this.renderDoc(output.stdout()));
        }
        if (output.stderr().isNotEmpty()) {
            this.errPrintln(this.renderDoc(output.stderr()));
        }
    }

    default public boolean loop(@NotNull String prompt, @NotNull CommandManager commandManager) {
        try {
            String line = this.readLine(prompt).trim();
            if (line.startsWith(":{") && line.endsWith(":}")) {
                String code = line.substring(":{".length(), line.length() - ":}".length());
                this.printResult(this.eval(code));
            } else {
                if (line.startsWith(":")) {
                    Command.Result result = commandManager.parse(line.substring(1)).run(this);
                    this.printResult(result.output());
                    return result.continueRepl();
                }
                this.printResult(this.eval(line));
            }
        }
        catch (EndOfFileException ignored) {
            return false;
        }
        catch (UserInterruptException ignored) {
        }
        catch (Throwable e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            this.errPrintln(stackTrace.toString());
        }
        return true;
    }

    @NotNull
    default public String renderDoc(@NotNull Doc doc) {
        return doc.debugRender();
    }
}

