/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.aya.repl.Command;
import org.aya.repl.CommandManager;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public interface ReplCompleters {
    @NotNull
    public static final Completer BOOL = (reader, line, candidates) -> {
        candidates.add(new Candidate("true"));
        candidates.add(new Candidate("false"));
    };

    public record Help(@NotNull Supplier<CommandManager> commandManager) implements Completer
    {
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            this.commandManager.get().cmd.view().map(CommandManager.CommandGen::owner).flatMap(Command::names).map(Candidate::new).forEach(candidates::add);
        }
    }

    public record EnumCompleter<T extends Enum<T>>(@NotNull Class<T> enumClass) implements Completer
    {
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(Candidate::new).forEach(candidates::add);
        }
    }
}

