/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl;

import java.nio.file.Path;
import kala.collection.SeqLike;
import kala.control.Option;
import org.aya.pretty.doc.Doc;
import org.aya.repl.Command;
import org.aya.repl.CommandManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public interface ReplUtil {
    @NotNull
    public static Command.Result invokeHelp(CommandManager commandManager, @Nullable HelpItem argument) {
        if (argument != null && !argument.cmd.isEmpty()) {
            Option cmd = commandManager.cmd.find(c -> c.owner().names().contains((Object)argument.cmd));
            if (cmd.isDefined()) {
                return Command.Result.ok(((CommandManager.CommandGen)cmd.get()).owner().help(), true);
            }
            return Command.Result.err("No such command: " + argument.cmd, true);
        }
        Doc commands = Doc.vcat((SeqLike)commandManager.cmd.view().map(command -> Doc.sep((Doc[])new Doc[]{Doc.commaList((SeqLike)command.owner().names().map(name -> Doc.plain((String)(":" + name)))), Doc.plain((String)"-"), Doc.english((String)command.owner().help())})));
        return new Command.Result(new Command.Output(commands, Doc.empty()), true);
    }

    @NotNull
    public static Path resolveFile(@NotNull String arg, Path cwd) {
        String homeAware = arg.replaceFirst("^~", System.getProperty("user.home"));
        Path path = Path.of(homeAware, new String[0]);
        return path.isAbsolute() ? path.normalize() : cwd.resolve(homeAware).toAbsolutePath().normalize();
    }

    @NotNull
    public static String red(@NotNull String x) {
        return new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(1)).append((CharSequence)x).style(AttributedStyle.DEFAULT).toAnsi();
    }

    public record HelpItem(@NotNull String cmd) {
    }
}

