/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl.antlr;

import java.util.Collections;
import java.util.List;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import org.antlr.v4.runtime.Token;
import org.aya.repl.CommandArg;
import org.aya.repl.CommandManager;
import org.aya.repl.antlr.AntlrLexer;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultParser;

public record ReplParser(@NotNull CommandManager cmd, @NotNull AntlrLexer lexer, @NotNull DefaultParser shellLike) implements Parser
{
    public ReplParser(@NotNull CommandManager cmd, @NotNull AntlrLexer lexer) {
        this(cmd, lexer, new DefaultParser());
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        boolean shellAlike;
        if (line.isBlank()) {
            return this.simplest(line, cursor, 0, Collections.emptyList());
        }
        if ((context == Parser.ParseContext.UNSPECIFIED || context == Parser.ParseContext.ACCEPT_LINE) && line.startsWith(":{") && !line.endsWith(":}")) {
            throw new EOFError(-1, cursor, "In multiline mode");
        }
        String trim = line.trim();
        if (trim.startsWith(":") && (shellAlike = this.cmd.parse(trim.substring(1)).command().view().mapNotNull(CommandManager.CommandGen::argFactory).anyMatch(CommandArg::shellLike))) {
            return this.shellLike.parse(line, cursor, context);
        }
        ImmutableSeq tokens = this.lexer.tokensNoEOF(line).filter(token -> token.getChannel() != 1).toImmutableSeq();
        Option wordOpt = tokens.firstOption(token -> token.getStartIndex() <= cursor && token.getStopIndex() + 1 >= cursor);
        if (wordOpt.isEmpty()) {
            Option tokenOpt = tokens.firstOption(tok -> tok.getStartIndex() >= cursor);
            if (tokenOpt.isEmpty()) {
                return this.simplest(line, cursor, tokens.size(), tokens.stream().map(Token::getText).toList());
            }
            Token token2 = (Token)tokenOpt.get();
            int wordCursor = cursor - token2.getStartIndex();
            return new ReplParsedLine(Math.max(wordCursor, 0), tokens.stream().map(Token::getText).toList(), token2.getText(), tokens.size() - 1, line, cursor);
        }
        Token word = (Token)wordOpt.get();
        String wordText = word.getText();
        return new ReplParsedLine(cursor - word.getStartIndex(), tokens.stream().map(Token::getText).toList(), wordText, tokens.indexOf((Object)word), line, cursor);
    }

    @NotNull
    public ReplParsedLine simplest(String line, int cursor, int wordIndex, List<@NotNull String> tokens) {
        return new ReplParsedLine(0, tokens, "", wordIndex, line, cursor);
    }

    public record ReplParsedLine(int wordCursor, @NotNull @NotNull List<@NotNull String> words, @NotNull String word, int wordIndex, @NotNull String line, int cursor) implements CompletingParsedLine
    {
        public CharSequence escape(CharSequence charSequence, boolean b) {
            return charSequence;
        }

        public int rawWordCursor() {
            return this.wordCursor;
        }

        public int rawWordLength() {
            return this.word.length();
        }
    }
}

