/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import kala.collection.immutable.ImmutableSeq;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Command {
    @NonNls
    @NotNull
    public static final String PREFIX = ":";
    @NonNls
    @NotNull
    public static final String MULTILINE_BEGIN = ":{";
    @NonNls
    @NotNull
    public static final String MULTILINE_END = ":}";
    @NotNull
    private final ImmutableSeq<String> names;
    @NotNull
    private final String help;

    public Command(@NotNull ImmutableSeq<String> names, @NotNull String help) {
        this.names = names;
        this.help = help;
    }

    @NotNull
    public final ImmutableSeq<String> names() {
        return this.names;
    }

    @NotNull
    public final String help() {
        return this.help;
    }

    public record Result(@NotNull Output output, boolean continueRepl) {
        @NotNull
        public static Result ok(@NotNull String text, boolean continueRepl) {
            return new Result(Output.stdout(Doc.english((String)text)), continueRepl);
        }

        @NotNull
        public static Result err(@NotNull String errText, boolean continueRepl) {
            return new Result(Output.stderr(Doc.english((String)errText)), continueRepl);
        }
    }

    public record Output(@NotNull Doc stdout, @NotNull Doc stderr) {
        @NotNull
        public static Output empty() {
            return new Output(Doc.empty(), Doc.empty());
        }

        @NotNull
        public static Output stdout(@NotNull Doc doc) {
            return new Output(doc, Doc.empty());
        }

        @NotNull
        public static Output stderr(@NotNull Doc doc) {
            return new Output(Doc.empty(), doc);
        }

        @NotNull
        public static Output stdout(@NotNull String doc) {
            return new Output(Doc.english((String)doc), Doc.empty());
        }

        @NotNull
        public static Output stderr(@NotNull String doc) {
            return new Output(Doc.empty(), Doc.english((String)doc));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Entry {
    }
}

