/*
 * Decompiled with CFR 0.152.
 */
package org.aya.repl.gk;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import java.util.Collections;
import java.util.List;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import org.aya.repl.CommandArg;
import org.aya.repl.CommandManager;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultParser;

public record ReplParser(@NotNull CommandManager cmd, @NotNull FlexLexer lexer, @NotNull DefaultParser shellLike) implements Parser
{
    public ReplParser(@NotNull CommandManager cmd, @NotNull FlexLexer lexer) {
        this(cmd, lexer, new DefaultParser());
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        boolean shellAlike;
        if (line.isBlank()) {
            return this.simplest(line, cursor, 0, Collections.emptyList());
        }
        if ((context == Parser.ParseContext.UNSPECIFIED || context == Parser.ParseContext.ACCEPT_LINE) && line.startsWith(":{") && !line.endsWith(":}")) {
            throw new EOFError(-1, cursor, "In multiline mode");
        }
        String trim = line.trim();
        if (trim.startsWith(":") && (shellAlike = this.cmd.parse(trim.substring(1)).command().view().mapNotNull(CommandManager.CommandGen::argFactory).anyMatch(CommandArg::shellLike))) {
            return this.shellLike.parse(line, cursor, context);
        }
        this.lexer.reset((CharSequence)line, 0, line.length(), 0);
        ImmutableSeq tokens = this.lexer.allTheWayDown().view().filter(x -> x.type() != TokenType.WHITE_SPACE).toImmutableSeq();
        Option wordOpt = tokens.firstOption(token -> token.range().containsOffset(cursor));
        if (wordOpt.isEmpty()) {
            Option tokenOpt = tokens.firstOption(tok -> tok.range().getStartOffset() >= cursor);
            if (tokenOpt.isEmpty()) {
                return this.simplest(line, cursor, tokens.size(), tokens.map(tok -> ReplParser.textOf(line, tok)).asJava());
            }
            FlexLexer.Token token2 = (FlexLexer.Token)tokenOpt.get();
            int wordCursor = cursor - token2.range().getStartOffset();
            return new ReplParsedLine(Math.max(wordCursor, 0), tokens.map(tok -> ReplParser.textOf(line, tok)).asJava(), ReplParser.textOf(line, token2), tokens.size() - 1, line, cursor);
        }
        FlexLexer.Token word = (FlexLexer.Token)wordOpt.get();
        String wordText = ReplParser.textOf(line, word);
        return new ReplParsedLine(cursor - word.range().getStartOffset(), tokens.stream().map(tok -> ReplParser.textOf(line, tok)).toList(), wordText, tokens.indexOf((Object)word), line, cursor);
    }

    @NotNull
    private static String textOf(String line, FlexLexer.Token tok) {
        return tok.range().substring(line);
    }

    @NotNull
    public ReplParsedLine simplest(String line, int cursor, int wordIndex, List<@NotNull String> tokens) {
        return new ReplParsedLine(0, tokens, "", wordIndex, line, cursor);
    }

    public record ReplParsedLine(int wordCursor, @NotNull @NotNull List<@NotNull String> words, @NotNull String word, int wordIndex, @NotNull String line, int cursor) implements CompletingParsedLine
    {
        public CharSequence escape(CharSequence charSequence, boolean b) {
            return charSequence;
        }

        public int rawWordCursor() {
            return this.wordCursor;
        }

        public int rawWordLength() {
            return this.word.length();
        }
    }
}

