/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FileUtil {
    @NotNull
    public static Path canonicalize(@NotNull Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException ignored) {
            return path.toAbsolutePath().normalize();
        }
    }

    public static void deleteRecursively(@NotNull Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            ((ImmutableSeq)walk.sorted(Comparator.reverseOrder()).collect(ImmutableSeq.factory())).forEachChecked(Files::deleteIfExists);
        }
    }

    @NotNull
    public static ImmutableSeq<Path> collectSource(@NotNull Path srcRoot, @NotNull String postfix) {
        return FileUtil.collectSource(srcRoot, postfix, Integer.MAX_VALUE);
    }

    @NotNull
    public static ImmutableSeq<Path> collectSource(@NotNull Path srcRoot, @NotNull String postfix, int maxDepth) {
        ImmutableSeq immutableSeq;
        block8: {
            Stream<Path> walk = Files.walk(srcRoot, maxDepth, new FileVisitOption[0]);
            try {
                immutableSeq = (ImmutableSeq)walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(postfix)).collect(ImmutableSeq.factory());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return ImmutableSeq.empty();
                }
            }
            walk.close();
        }
        return immutableSeq;
    }

    @NotNull
    public static ObjectInputStream ois(@NotNull Path corePath) throws IOException {
        return new ObjectInputStream(Files.newInputStream(corePath, new OpenOption[0]));
    }

    @NotNull
    public static Path resolveFile(@NotNull Path basePath, @NotNull @NotNull Seq<@NotNull String> moduleName, String postfix) {
        Path withoutExt = (Path)moduleName.foldLeft((Object)basePath, Path::resolve);
        return withoutExt.resolveSibling(withoutExt.getFileName() + postfix);
    }

    @Nullable
    public static Path resolveFile(@NotNull SeqView<Path> basePaths, @NotNull Seq<String> moduleName, String postfix) {
        return (Path)basePaths.map(basePath -> FileUtil.resolveFile(basePath, moduleName, postfix)).firstOrNull(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }
}

