/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.collection.mutable.MutableSinglyLinkedList;
import org.jetbrains.annotations.NotNull;

public record MutableGraph<T>(@NotNull @NotNull MutableMap<T, @NotNull MutableList<@NotNull T>> E) {
    @NotNull
    public static <T> MutableGraph<T> create() {
        return new MutableGraph<T>(MutableLinkedHashMap.of());
    }

    @NotNull
    public MutableList<T> sucMut(@NotNull T elem) {
        return (MutableList)this.E.getOrPut(elem, MutableList::of);
    }

    @NotNull
    public SeqView<T> suc(@NotNull T elem) {
        MutableList suc = (MutableList)this.E.getOrNull(elem);
        return suc == null ? SeqView.empty() : suc.view();
    }

    public boolean hasPath(@NotNull T from, @NotNull T to) {
        return this.hasPath(MutableSet.create(), from, to);
    }

    private boolean hasPath(@NotNull MutableSet<T> book, @NotNull T from, @NotNull T to) {
        if (from == to) {
            return true;
        }
        if (book.contains(from)) {
            return false;
        }
        book.add(from);
        for (Object test : this.suc(from)) {
            if (!this.hasPath(book, test, to)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ImmutableSeq<ImmutableSeq<T>> findCycles() {
        return this.topologicalOrder().filter(scc -> scc.sizeGreaterThan(1));
    }

    public ImmutableSeq<ImmutableSeq<T>> topologicalOrder() {
        return new Tarjan().tarjan();
    }

    @NotNull
    public MutableGraph<T> transpose() {
        MutableGraph tr = MutableGraph.create();
        this.E.forEach((v, ws) -> {
            tr.sucMut(v);
            ws.forEach(w -> tr.sucMut(w).append(v));
        });
        return tr;
    }

    private class Tarjan {
        final MutableMap<T, Info> info = MutableLinkedHashMap.of();
        final MutableSinglyLinkedList<T> stack = MutableSinglyLinkedList.create();
        final MutableList<ImmutableSeq<T>> SCCs = MutableList.create();
        int index = 0;

        private Tarjan() {
        }

        @NotNull
        private Info info(@NotNull T t) {
            return (Info)this.info.getOrPut(t, Info::new);
        }

        private void push(@NotNull T v) {
            this.stack.push(v);
            this.info(v).free = true;
        }

        @NotNull
        private T pop() {
            Object v = this.stack.pop();
            this.info(v).free = false;
            return v;
        }

        public void makeSCC(@NotNull T v) {
            Info infoV = this.info(v);
            infoV.lowlink = this.index++;
            infoV.index = infoV.lowlink;
            this.push(v);
            MutableGraph.this.suc(v).forEach(w -> {
                Info infoW = this.info(w);
                if (infoW.noIndex()) {
                    this.makeSCC(w);
                    infoV.lowlink = Math.min(infoV.lowlink, infoW.lowlink);
                } else if (infoW.free) {
                    infoV.lowlink = Math.min(infoV.lowlink, infoW.index);
                }
            });
            if (infoV.lowlink == infoV.index) {
                MutableList scc = MutableList.create();
                Object t = null;
                while (v != t) {
                    t = this.pop();
                    scc.append(t);
                }
                this.SCCs.append((Object)scc.toImmutableSeq());
            }
        }

        public ImmutableSeq<ImmutableSeq<T>> tarjan() {
            MutableGraph.this.E.keysView().filter(v -> this.info(v).noIndex()).forEach(this::makeSCC);
            return this.SCCs.toImmutableSeq();
        }
    }

    private static class Info {
        static final int INDEX_NONE = Integer.MAX_VALUE;
        int index = Integer.MAX_VALUE;
        int lowlink = Integer.MAX_VALUE;
        boolean free = false;

        private Info() {
        }

        boolean noIndex() {
            return this.index == Integer.MAX_VALUE;
        }
    }
}

