/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.binop;

import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.Set;
import kala.collection.mutable.MutableLinkedList;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.collection.mutable.MutableSinglyLinkedList;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.BinOpSet;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BinOpParser<OpSet extends BinOpSet, Expr extends SourceNode, Arg extends Elem<Expr>> {
    @NotNull
    protected final OpSet opSet;
    @NotNull
    private final @NotNull SeqView<@NotNull Arg> seq;
    private final MutableSinglyLinkedList<Tuple2<Arg, BinOpSet.BinOP>> opStack = MutableSinglyLinkedList.create();
    private final MutableLinkedList<Arg> prefixes = MutableLinkedList.create();
    private final MutableMap<Arg, MutableSet<AppliedSide>> appliedOperands = MutableMap.create();

    public BinOpParser(@NotNull OpSet opSet, @NotNull @NotNull SeqView<@NotNull Arg> seq) {
        this.opSet = opSet;
        this.seq = seq;
    }

    @NotNull
    protected abstract BinOpParser<OpSet, Expr, Arg> replicate(@NotNull @NotNull SeqView<@NotNull Arg> var1);

    @NotNull
    protected abstract Arg appOp();

    @NotNull
    public Expr build(@NotNull SourcePos sourcePos) {
        if (this.seq.sizeEquals(1)) {
            return ((Elem)this.seq.get(0)).expr();
        }
        if (this.seq.sizeEquals(2)) {
            Elem first = (Elem)this.seq.get(0);
            Elem second = (Elem)this.seq.get(1);
            if (((BinOpSet)this.opSet).assocOf((OpDecl)this.underlyingOpDecl(first)).infix && this.toSetElem((Arg)first, (BinOpSet)this.opSet).argc() == 2) {
                return this.makeSectionApp(sourcePos, first, elem -> this.replicate(this.seq.prepended(elem)).build(sourcePos)).expr();
            }
            if (((BinOpSet)this.opSet).assocOf((OpDecl)this.underlyingOpDecl(second)).infix && this.toSetElem((Arg)second, (BinOpSet)this.opSet).argc() == 2) {
                return this.makeSectionApp(sourcePos, second, elem -> this.replicate(this.seq.appended(elem)).build(sourcePos)).expr();
            }
        }
        return this.convertToPrefix(sourcePos);
    }

    @NotNull
    public abstract Arg makeSectionApp(@NotNull SourcePos var1, @NotNull Arg var2, @NotNull Function<Arg, Expr> var3);

    @NotNull
    private Expr convertToPrefix(@NotNull SourcePos sourcePos) {
        for (Elem expr : this.insertApplication()) {
            if (this.isOperand((Arg)expr, (BinOpSet)this.opSet)) {
                this.prefixes.append((Object)expr);
                continue;
            }
            BinOpSet.BinOP currentOp = this.toSetElem((Arg)expr, (BinOpSet)this.opSet);
            while (this.opStack.isNotEmpty()) {
                Tuple2 top = (Tuple2)this.opStack.peek();
                BinOpSet.PredCmp cmp = ((BinOpSet)this.opSet).compare((BinOpSet.BinOP)top._2, currentOp);
                if (cmp == BinOpSet.PredCmp.Tighter) {
                    this.foldLhsFor(expr);
                    continue;
                }
                if (cmp == BinOpSet.PredCmp.Equal) {
                    Assoc currentAssoc;
                    Assoc topAssoc = ((BinOpSet.BinOP)top._2).assoc();
                    if (topAssoc != (currentAssoc = currentOp.assoc()) || topAssoc == Assoc.Infix) {
                        this.reportFixityError(topAssoc, currentAssoc, ((BinOpSet.BinOP)top._2).name(), currentOp.name(), ((Elem)top._1).sourcePos());
                        return this.createErrorExpr(sourcePos);
                    }
                    if (topAssoc != Assoc.InfixL) break;
                    this.foldLhsFor(expr);
                    continue;
                }
                if (cmp == BinOpSet.PredCmp.Looser) break;
                this.reportAmbiguousPred(currentOp.name(), ((BinOpSet.BinOP)top._2).name(), ((Elem)top._1).sourcePos());
                return this.createErrorExpr(sourcePos);
            }
            this.opStack.push((Object)Tuple.of((Object)expr, (Object)currentOp));
        }
        while (this.opStack.isNotEmpty()) {
            this.foldTop();
            if (!this.opStack.isNotEmpty()) continue;
            this.markAppliedOperand((Elem)((Tuple2)this.opStack.peek())._1, AppliedSide.Rhs);
        }
        assert (this.prefixes.sizeEquals(1));
        return ((Elem)this.prefixes.first()).expr();
    }

    protected abstract void reportAmbiguousPred(String var1, String var2, SourcePos var3);

    protected abstract void reportFixityError(Assoc var1, Assoc var2, String var3, String var4, SourcePos var5);

    @NotNull
    protected abstract Expr createErrorExpr(@NotNull SourcePos var1);

    @NotNull
    private Seq<Arg> insertApplication() {
        MutableList seqWithApp = MutableList.create();
        boolean lastIsOperand = true;
        for (Elem expr : this.seq) {
            boolean isOperand = this.isOperand((Arg)expr, (BinOpSet)this.opSet);
            if (isOperand && lastIsOperand && seqWithApp.isNotEmpty()) {
                seqWithApp.append(this.appOp());
            }
            lastIsOperand = isOperand;
            seqWithApp.append((Object)expr);
        }
        return seqWithApp;
    }

    private void markAppliedOperand(@NotNull Arg elem, @NotNull AppliedSide side) {
        ((MutableSet)this.appliedOperands.getOrPut(elem, MutableSet::of)).add((Object)side);
    }

    @NotNull
    private Set<AppliedSide> getAppliedSides(@NotNull Arg elem) {
        return (Set)this.appliedOperands.getOrPut(elem, MutableSet::of);
    }

    private void foldLhsFor(@NotNull Arg forOp) {
        this.foldTop();
        this.markAppliedOperand(forOp, AppliedSide.Lhs);
    }

    private void foldTop() {
        Tuple2 op = (Tuple2)this.opStack.pop();
        this.prefixes.append((Object)this.makeBinApp((Elem)op._1));
    }

    @NotNull
    private Arg makeBinApp(@NotNull Arg op) {
        int argc = this.toSetElem(op, (BinOpSet)this.opSet).argc();
        if (argc == 1) {
            Elem operand = (Elem)this.prefixes.dequeue();
            return (Arg)this.makeArg(this.union(operand, op), op.expr(), operand, op.explicit());
        }
        if (argc == 2) {
            if (this.prefixes.sizeGreaterThanOrEquals(2)) {
                Elem rhs = (Elem)this.prefixes.dequeue();
                Elem lhs = (Elem)this.prefixes.dequeue();
                return (Arg)this.makeBinApp(op, rhs, lhs);
            }
            if (this.prefixes.sizeEquals(1)) {
                Set<AppliedSide> sides = this.getAppliedSides(op);
                Elem applied = (Elem)this.prefixes.dequeue();
                AppliedSide side = (AppliedSide)((Object)sides.elementAt(0));
                return (Arg)this.makeSectionApp(this.union(op, applied), op, elem -> (switch (side) {
                    default -> throw new IncompatibleClassChangeError();
                    case AppliedSide.Lhs -> this.makeBinApp(op, elem, applied);
                    case AppliedSide.Rhs -> this.makeBinApp(op, applied, elem);
                }).expr());
            }
        }
        throw new UnsupportedOperationException("TODO?");
    }

    @NotNull
    private Arg makeBinApp(@NotNull Arg op, @NotNull Arg rhs, @NotNull Arg lhs) {
        boolean explicit = op.explicit();
        if (op == this.appOp()) {
            return this.makeArg(this.union(lhs, rhs), lhs.expr(), rhs, explicit);
        }
        return this.makeArg(this.union(op, lhs, rhs), this.makeArg(this.union(op, lhs), op.expr(), lhs, true).expr(), rhs, explicit);
    }

    public boolean isOperand(@NotNull Arg elem, @NotNull BinOpSet opSet) {
        if (elem == this.appOp()) {
            return false;
        }
        OpDecl tryOp = this.underlyingOpDecl(elem);
        return opSet.isOperand(tryOp);
    }

    public @NotNull BinOpSet.BinOP toSetElem(@NotNull Arg elem, @NotNull BinOpSet opSet) {
        if (elem == this.appOp()) {
            return BinOpSet.APP_ELEM;
        }
        OpDecl tryOp = this.underlyingOpDecl(elem);
        assert (tryOp != null);
        return opSet.ensureHasElem(tryOp);
    }

    @Nullable
    protected abstract OpDecl underlyingOpDecl(@NotNull Arg var1);

    @NotNull
    protected abstract Arg makeArg(@NotNull SourcePos var1, @NotNull Expr var2, @NotNull Arg var3, boolean var4);

    @NotNull
    private SourcePos union(@NotNull Arg a, @NotNull Arg b, @NotNull Arg c) {
        return this.union(a, b).union(c.sourcePos());
    }

    @NotNull
    private SourcePos union(@NotNull Arg a, @NotNull Arg b) {
        return a.sourcePos().union(b.sourcePos());
    }

    public static interface Elem<Expr extends SourceNode>
    extends SourceNode {
        @NotNull
        public Expr expr();

        public boolean explicit();

        @Override
        @NotNull
        default public SourcePos sourcePos() {
            return this.expr().sourcePos();
        }
    }

    static enum AppliedSide {
        Lhs,
        Rhs;

    }
}

