/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.distill;

import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class DistillerOptions {
    @NotNull
    public final Map<Key, Boolean> map = new EnumMap<Key, Boolean>(Key.class);

    public DistillerOptions() {
        this.reset();
    }

    public void reset() {
        for (Key value : Key.values()) {
            this.map.put(value, false);
        }
        this.map.put(Key.InlineMetas, true);
    }

    @Contract(pure=true, value="->new")
    @NotNull
    public static DistillerOptions debug() {
        DistillerOptions map = DistillerOptions.informative();
        map.map.put(Key.ShowLambdaTypes, true);
        return map;
    }

    @Contract(pure=true, value="->new")
    @NotNull
    public static DistillerOptions informative() {
        DistillerOptions map = DistillerOptions.pretty();
        map.map.put(Key.ShowImplicitArgs, true);
        return map;
    }

    @Contract(pure=true, value="->new")
    @NotNull
    public static DistillerOptions pretty() {
        DistillerOptions map = new DistillerOptions();
        map.map.put(Key.ShowImplicitPats, true);
        map.map.put(Key.ShowLevels, true);
        map.map.put(Key.ShowLiterals, true);
        return map;
    }

    public static enum Key {
        InlineMetas,
        ShowImplicitArgs,
        ShowImplicitPats,
        ShowLambdaTypes,
        ShowLevels,
        ShowLiterals;

    }
}

