/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.error;

import java.nio.file.Path;
import kala.collection.SeqLike;
import kala.control.Option;
import org.jetbrains.annotations.NotNull;

public interface SourceFileLocator {
    @NotNull
    default public Path displayName(@NotNull Path path) {
        return path;
    }

    public record Module(@NotNull SeqLike<Path> modulePath) implements SourceFileLocator
    {
        @Override
        @NotNull
        public Path displayName(@NotNull Path path) {
            Path normalized = path.toAbsolutePath().normalize();
            Option found = this.modulePath.find(m -> normalized.startsWith(m.toAbsolutePath()));
            if (found.isDefined()) {
                return ((Path)found.get()).toAbsolutePath().normalize().relativize(normalized);
            }
            return path;
        }
    }
}

