/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.reporter;

import java.util.Arrays;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;

public interface CountingReporter
extends Reporter {
    public int problemSize(@NotNull Problem.Severity var1);

    public void clear();

    default public int errorSize() {
        return this.problemSize(Problem.Severity.ERROR);
    }

    default public int warningSize() {
        return this.problemSize(Problem.Severity.WARN);
    }

    default public boolean noError() {
        return this.errorSize() == 0;
    }

    default public boolean anyError() {
        return !this.noError();
    }

    @NotNull
    default public String countToString() {
        return String.format("%d error(s), %d warning(s).", this.errorSize(), this.warningSize());
    }

    @NotNull
    public static CountingReporter of(@NotNull Reporter reporter) {
        CountingReporter counting;
        return reporter instanceof CountingReporter ? (counting = (CountingReporter)reporter) : CountingReporter.delegate(reporter);
    }

    @NotNull
    public static CountingReporter delegate(@NotNull Reporter reporter) {
        return new Delegated(reporter);
    }

    public record Delegated(@NotNull Reporter delegated, int @NotNull [] count) implements CountingReporter
    {
        public Delegated(@NotNull Reporter delegated) {
            this(delegated, new int[((Problem.Severity[])Problem.Severity.class.getEnumConstants()).length]);
        }

        @Override
        public int problemSize(@NotNull Problem.Severity severity) {
            return this.count[severity.ordinal()];
        }

        @Override
        public void clear() {
            Arrays.fill(this.count, 0);
        }

        @Override
        public void report(@NotNull Problem problem) {
            if (problem.sourcePos() != SourcePos.NONE) {
                int n = problem.level().ordinal();
                this.count[n] = this.count[n] + 1;
            }
            this.delegated.report(problem);
        }
    }
}

