/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.reporter;

import org.aya.pretty.doc.Doc;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Reporter {
    public void report(@NotNull Problem var1);

    @ApiStatus.Internal
    default public void reportString(@NotNull String s) {
        this.reportDoc(Doc.english((String)s));
    }

    @ApiStatus.Internal
    default public void reportNest(@NotNull String text, int indent) {
        this.reportDoc(Doc.nest((int)indent, (Doc)Doc.english((String)text)));
    }

    @ApiStatus.Internal
    default public void reportDoc(final @NotNull Doc doc) {
        this.report(new Problem(){

            @Override
            @NotNull
            public SourcePos sourcePos() {
                return SourcePos.NONE;
            }

            @Override
            @NotNull
            public Problem.Severity level() {
                return Problem.Severity.INFO;
            }

            @Override
            @NotNull
            public Doc describe(@NotNull DistillerOptions options) {
                return doc;
            }
        });
    }
}

