/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.reporter;

import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaStyleFamily;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public record ThrowingReporter() implements Reporter
{
    @NotNull
    public static final ThrowingReporter INSTANCE = new ThrowingReporter();

    @NotNull
    public static String errorMessage(@NotNull Problem problem, @NotNull DistillerOptions options, boolean unicode, boolean supportAnsi, int pageWidth) {
        Doc doc;
        Doc doc2 = doc = problem.sourcePos() == SourcePos.NONE ? problem.describe(options) : problem.toPrettyError(options).toDoc();
        if (supportAnsi) {
            StringPrinterConfig config = StringPrinterConfig.unixTerminal((StyleFamily)AyaStyleFamily.ADAPTIVE_CLI, (int)pageWidth, (boolean)unicode);
            return doc.renderToString(config);
        }
        return doc.renderWithPageWidth(pageWidth, unicode);
    }

    @Override
    public void report(@NotNull Problem problem) {
        String render = ThrowingReporter.errorMessage(problem, DistillerOptions.informative(), false, false, 80);
        if (problem.level() != Problem.Severity.ERROR) {
            System.err.println(render);
            return;
        }
        throw new AssertionError((Object)("Failed with `" + problem.getClass() + "`: " + render + "\nat " + problem.sourcePos()));
    }
}

