/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Function;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.Tuple3;
import org.jetbrains.annotations.NotNull;

public interface ArrayUtil {
    public static <A> void fill(A @NotNull [] @NotNull [] a, @NotNull A value) {
        for (Object[] objectArray : a) {
            Arrays.fill(objectArray, value);
        }
    }

    public static <A> A @NotNull [] map(A @NotNull [] array, Function<A, A> f) {
        Object[] a = (Object[])Array.newInstance(array.getClass().componentType(), array.length);
        for (int i = 0; i < array.length; ++i) {
            a[i] = f.apply(array[i]);
        }
        return a;
    }

    public static <A, B> B @NotNull [] map(A @NotNull [] array, B @NotNull [] outTyper, Function<A, B> f) {
        Object[] b = (Object[])Array.newInstance(outTyper.getClass().componentType(), array.length);
        for (int i = 0; i < array.length; ++i) {
            b[i] = f.apply(array[i]);
        }
        return b;
    }

    public static <A> A @NotNull [] map(A @NotNull [] array, Function<A, A> f, int start, int end) {
        Object[] a = (Object[])Array.newInstance(array.getClass().componentType(), end - start);
        for (int i = start; i < end; ++i) {
            a[i - start] = f.apply(array[i]);
        }
        return a;
    }

    public static <A> A @NotNull [] map(A @NotNull [] array, Function<A, A> f, int start) {
        return ArrayUtil.map(array, f, start, array.length);
    }

    @NotNull
    public static <A, B> @NotNull Tuple2<A, B> @NotNull [] zip(A @NotNull [] a, B @NotNull [] b) {
        int len = Math.min(a.length, b.length);
        Tuple2[] c = new Tuple2[len];
        for (int i = 0; i < len; ++i) {
            c[i] = Tuple.of(a[i], b[i]);
        }
        return c;
    }

    @NotNull
    public static <A, B, C> @NotNull Tuple3<A, B, C> @NotNull [] zip(A @NotNull [] a, B @NotNull [] b, C @NotNull [] c) {
        int len = Math.min(a.length, Math.min(b.length, c.length));
        Tuple3[] d = new Tuple3[len];
        for (int i = 0; i < len; ++i) {
            d[i] = Tuple.of(a[i], b[i], c[i]);
        }
        return d;
    }

    public static <A> boolean identical(A @NotNull [] a, A @NotNull [] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

