/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.binop;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.terck.MutableGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BinOpSet {
    @NotNull
    public final MutableGraph<BinOP> tighterGraph = MutableGraph.create();
    @NotNull
    public final MutableSet<BinOP> ops = MutableSet.of((Object)APP_ELEM);
    @NotNull
    public static final BinOP APP_ELEM = BinOP.from(SourcePos.NONE, OpDecl.APPLICATION);

    public void bind(@NotNull OpDecl op, @NotNull OpDecl.BindPred pred, @NotNull OpDecl target, @NotNull SourcePos sourcePos) {
        BinOP targetElem;
        BinOP opElem = this.ensureHasElem(op, sourcePos);
        if (opElem == (targetElem = this.ensureHasElem(target, sourcePos))) {
            this.reportSelfBind(sourcePos);
        }
        switch (pred) {
            case Tighter: {
                this.addTighter(opElem, targetElem);
                break;
            }
            case Looser: {
                this.addTighter(targetElem, opElem);
            }
        }
    }

    public PredCmp compare(@NotNull BinOP lhs, @NotNull BinOP rhs) {
        if (lhs == APP_ELEM) {
            return PredCmp.Tighter;
        }
        if (rhs == APP_ELEM) {
            return PredCmp.Looser;
        }
        if (lhs == rhs) {
            return PredCmp.Equal;
        }
        if (this.tighterGraph.hasPath(lhs, rhs)) {
            return PredCmp.Tighter;
        }
        if (this.tighterGraph.hasPath(rhs, lhs)) {
            return PredCmp.Looser;
        }
        return PredCmp.Undefined;
    }

    public Assoc assocOf(@Nullable OpDecl opDecl) {
        if (this.isOperand(opDecl)) {
            return Assoc.Invalid;
        }
        return this.ensureHasElem((OpDecl)opDecl).assoc;
    }

    public final boolean isOperand(@Nullable OpDecl opDecl) {
        return opDecl == null || opDecl.opInfo() == null;
    }

    public BinOP ensureHasElem(@NotNull OpDecl opDecl) {
        return this.ensureHasElem(opDecl, SourcePos.NONE);
    }

    public BinOP ensureHasElem(@NotNull OpDecl opDecl, @NotNull SourcePos sourcePos) {
        Option elem = this.ops.find(e -> e.op == opDecl);
        if (elem.isDefined()) {
            return (BinOP)elem.get();
        }
        BinOP newElem = BinOP.from(sourcePos, opDecl);
        this.ops.add((Object)newElem);
        return newElem;
    }

    private void addTighter(@NotNull BinOP from, @NotNull BinOP to) {
        this.tighterGraph.sucMut(to);
        this.tighterGraph.sucMut(from).append((Object)to);
    }

    public void reportIfCyclic() {
        ImmutableSeq<ImmutableSeq<BinOP>> cycles = this.tighterGraph.findCycles();
        if (cycles.isNotEmpty()) {
            this.reportCyclic(cycles);
        }
    }

    protected abstract void reportSelfBind(@NotNull SourcePos var1);

    protected abstract void reportCyclic(ImmutableSeq<ImmutableSeq<BinOP>> var1);

    public void importBind(@NotNull BinOpSet other, @NotNull SourcePos sourcePos) {
        other.tighterGraph.E().view().forEach((from, tos) -> {
            BinOP fromOp = this.ensureHasElem(from.op, sourcePos);
            tos.forEach(to -> {
                BinOP toOp = this.ensureHasElem(to.op, sourcePos);
                this.addTighter(fromOp, toOp);
            });
        });
    }

    public record BinOP(@NotNull SourcePos firstBind, @NotNull OpDecl op, @NotNull String name, @NotNull Assoc assoc) {
        @NotNull
        private static OpDecl.OpInfo ensureOperator(@NotNull OpDecl opDecl) {
            OpDecl.OpInfo op = opDecl.opInfo();
            if (op == null) {
                throw new IllegalArgumentException("not an operator");
            }
            return op;
        }

        @NotNull
        private static BinOP from(@NotNull SourcePos sourcePos, @NotNull OpDecl opDecl) {
            OpDecl.OpInfo op = BinOP.ensureOperator(opDecl);
            return new BinOP(sourcePos, opDecl, op.name(), op.assoc());
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static enum PredCmp {
        Looser,
        Tighter,
        Undefined,
        Equal;

    }
}

