/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.reporter;

import java.util.Map;
import java.util.stream.Collectors;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import org.aya.pretty.backend.string.custom.UnixTermStyle;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.aya.pretty.error.PrettyError;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.NotNull;

public interface Problem {
    @NotNull
    public static final Styles ERROR = Style.bold().and().custom((Style.CustomStyle)UnixTermStyle.TerminalRed);
    @NotNull
    public static final Styles NOTE = Style.bold().and().custom((Style.CustomStyle)UnixTermStyle.TerminalGreen);
    @NotNull
    public static final Styles TEXT = Style.bold().and();

    @NotNull
    public SourcePos sourcePos();

    @NotNull
    public Doc describe(@NotNull DistillerOptions var1);

    @NotNull
    public Severity level();

    @NotNull
    default public Stage stage() {
        return Stage.OTHER;
    }

    @NotNull
    default public Doc hint(@NotNull DistillerOptions options) {
        return Doc.empty();
    }

    @NotNull
    default public SeqView<WithPos<Doc>> inlineHints(@NotNull DistillerOptions options) {
        return SeqView.empty();
    }

    default public boolean isError() {
        return this.level() == Severity.ERROR;
    }

    @NotNull
    default public PrettyError toPrettyError(@NotNull DistillerOptions options) {
        SourcePos sourcePos = this.sourcePos();
        return new PrettyError(sourcePos.file().display(), sourcePos.toSpan(), this.brief(options), (ImmutableSeq)this.inlineHints(options).stream().collect(Collectors.groupingBy(WithPos::sourcePos, Collectors.mapping(WithPos::data, Seq.factory()))).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(kv -> Tuple.of((Object)((SourcePos)kv.getKey()).toSpan(), (Object)Doc.commaList((SeqLike)((SeqLike)kv.getValue())))).collect(ImmutableSeq.factory()));
    }

    @NotNull
    default public Doc brief(@NotNull DistillerOptions options) {
        Doc tag = switch (this.level()) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.WARN -> Doc.plain((String)"Warning:");
            case Severity.GOAL -> Doc.plain((String)"Goal:");
            case Severity.INFO -> Doc.plain((String)"Info:");
            case Severity.ERROR -> Doc.styled((Styles)ERROR, (String)"Error:");
        };
        Doc doc = Doc.sep((Doc[])new Doc[]{tag, Doc.styled((Styles)TEXT, (Doc)Doc.align((Doc)this.describe(options)))});
        Doc hint = this.hint(options);
        return hint instanceof Doc.Empty ? doc : Doc.vcat((Doc[])new Doc[]{doc, Doc.sep((Doc[])new Doc[]{Doc.styled((Styles)NOTE, (String)"note:"), Doc.styled((Styles)TEXT, (Doc)Doc.align((Doc)hint))})});
    }

    public static enum Stage {
        TERCK,
        TYCK,
        RESOLVE,
        PARSE,
        OTHER;

    }

    public static enum Severity {
        ERROR,
        GOAL,
        WARN,
        INFO;

    }
}

