/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.reporter;

import org.aya.pretty.doc.Doc;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Reporter {
    public void report(@NotNull Problem var1);

    @ApiStatus.Internal
    default public void reportString(@NotNull String s) {
        this.reportString(s, Problem.Severity.INFO);
    }

    @ApiStatus.Internal
    default public void reportString(@NotNull String s, Problem.Severity severity) {
        this.reportDoc(Doc.english((String)s), severity);
    }

    @ApiStatus.Internal
    default public void reportNest(@NotNull String text, int indent) {
        this.reportNest(text, indent, Problem.Severity.INFO);
    }

    @ApiStatus.Internal
    default public void reportNest(@NotNull String text, int indent, Problem.Severity severity) {
        this.reportDoc(Doc.nest((int)indent, (Doc)Doc.english((String)text)), severity);
    }

    @ApiStatus.Internal
    default public void reportDoc(@NotNull Doc doc, Problem.Severity severity) {
        this.report(Reporter.dummyProblem(doc, severity));
    }

    @NotNull
    public static Problem dummyProblem(final @NotNull Doc doc, final Problem.Severity severity) {
        return new Problem(){

            @Override
            @NotNull
            public SourcePos sourcePos() {
                return SourcePos.NONE;
            }

            @Override
            @NotNull
            public Problem.Severity level() {
                return severity;
            }

            @Override
            @NotNull
            public Doc describe(@NotNull DistillerOptions options) {
                return doc;
            }
        };
    }
}

