/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicForest {
    @NotNull
    public static Handle create() {
        return new Handle(new Node());
    }

    public static final class Handle {
        @NotNull
        private final Node node;

        private Handle(@NotNull Node node) {
            this.node = node;
        }

        public boolean isConnected(@NotNull Handle v) {
            if (this.node == v.node) {
                return true;
            }
            this.node.liftToRoot();
            v.node.extendToRoot();
            v.node.splay();
            return v.node.findMin() == this.node;
        }

        public boolean isDirectlyConnected(@NotNull Handle v) {
            this.node.liftToRoot();
            v.node.extendToRoot();
            v.node.splay();
            v.node.pushDown();
            return v.node.left != null && v.node.left.findMax() == this.node;
        }

        public void connectUnchecked(@NotNull Handle v) {
            v.node.liftToRoot();
            v.node.upper = this.node;
        }

        public void disconnectUnchecked(@NotNull Handle v) {
            this.node.liftToRoot();
            v.node.extendToRoot();
            v.node.splay();
            v.node.pushDown();
            assert (v.node.left != null);
            v.node.left.parent = null;
            v.node.left = null;
        }

        public void connect(@NotNull Handle v) {
            if (this.node != v.node && !this.isConnected(v)) {
                this.connectUnchecked(v);
            }
        }

        public void disconnect(@NotNull Handle v) {
            if (this.node != v.node && this.isDirectlyConnected(v)) {
                this.disconnectUnchecked(v);
            }
        }
    }

    private static final class Node {
        @Nullable
        Node parent = null;
        @Nullable
        Node upper;
        @Nullable
        Node left = null;
        @Nullable
        Node right = null;
        boolean reversed = false;

        @Nullable
        Node getChild(boolean isRight) {
            if (isRight) {
                return this.right;
            }
            return this.left;
        }

        void setChild(boolean isRight, @Nullable Node target) {
            if (isRight) {
                this.right = target;
            } else {
                this.left = target;
            }
        }

        boolean isRightChild() {
            return null != this.parent && this == this.parent.right;
        }

        Node() {
        }

        void pushDown() {
            if (this.reversed) {
                Node tmp = this.left;
                this.left = this.right;
                this.right = tmp;
                if (null != this.left) {
                    boolean bl = this.left.reversed = !this.left.reversed;
                }
                if (null != this.right) {
                    this.right.reversed = !this.right.reversed;
                }
                this.reversed = false;
            }
        }

        void rotate() {
            assert (null != this.parent);
            if (null != this.parent.parent) {
                this.parent.parent.pushDown();
            }
            this.parent.pushDown();
            this.pushDown();
            Node tmp = this.parent.upper;
            this.parent.upper = this.upper;
            this.upper = tmp;
            boolean isRight = this.isRightChild();
            Node parentBackup = this.parent;
            if (null != parentBackup.parent) {
                parentBackup.parent.setChild(parentBackup.isRightChild(), this);
            }
            this.parent = parentBackup.parent;
            Node targetChild = this.getChild(!isRight);
            parentBackup.setChild(isRight, targetChild);
            if (null != targetChild) {
                targetChild.parent = parentBackup;
            }
            this.setChild(!isRight, parentBackup);
            parentBackup.parent = this;
        }

        void splay() {
            while (null != this.parent) {
                if (null == this.parent.parent) {
                    this.rotate();
                    continue;
                }
                this.parent.parent.pushDown();
                this.parent.pushDown();
                if (this.isRightChild() == this.parent.isRightChild()) {
                    this.parent.rotate();
                    this.rotate();
                    continue;
                }
                this.rotate();
                this.rotate();
            }
        }

        void separateDeeperNodes() {
            this.splay();
            this.pushDown();
            if (null != this.right) {
                this.right.parent = null;
                this.right.upper = this;
                this.right = null;
            }
        }

        boolean extendToUpper() {
            this.splay();
            if (null == this.upper) {
                return false;
            }
            this.upper.separateDeeperNodes();
            this.upper.right = this;
            this.parent = this.upper;
            this.upper = null;
            return true;
        }

        void extendToRoot() {
            this.separateDeeperNodes();
            boolean extensible = true;
            while (extensible) {
                extensible = this.extendToUpper();
            }
        }

        void liftToRoot() {
            this.extendToRoot();
            this.splay();
            this.reversed = !this.reversed;
        }

        Node findMin() {
            Node x = this;
            x.pushDown();
            while (null != x.left) {
                x = x.left;
                x.pushDown();
            }
            x.splay();
            return x;
        }

        Node findMax() {
            Node x = this;
            x.pushDown();
            while (null != x.right) {
                x = x.right;
                x.pushDown();
            }
            x.splay();
            return x;
        }
    }
}

