/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.tuple.primitive.IntObjTuple2;
import org.jetbrains.annotations.NotNull;

public interface StringUtil {
    @NotNull
    public static String timeToString(long time) {
        if (time < 10000L) {
            return time + "ms";
        }
        if (time < 60000L) {
            return time / 1000L + "." + time / 100L % 10L + "s";
        }
        long seconds = time / 1000L;
        return seconds / 60L + "m" + seconds % 60L + "s";
    }

    @NotNull
    public static ImmutableSeq<IntObjTuple2<String>> indexedLines(@NotNull String str) {
        ImmutableSeq lines = ImmutableSeq.from(str.lines());
        MutableList results = MutableList.create();
        int index = 0;
        for (String line : lines) {
            results.append((Object)IntObjTuple2.of((int)index, (Object)line));
            index = index + line.length() + 1;
        }
        return results.toImmutableSeq();
    }
}

