/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import kala.collection.mutable.MutableList;
import org.jetbrains.annotations.NotNull;

public abstract class TreeBuilder<T extends Tree<T>> {
    protected final Deque<@NotNull MutableList<@NotNull T>> tops = new ArrayDeque<MutableList<T>>();

    public TreeBuilder() {
        this.tops.addLast(MutableList.create());
    }

    @NotNull
    public @NotNull MutableList<@NotNull T> root() {
        return this.tops.getFirst();
    }

    public void append(@NotNull T trace) {
        this.shift(trace);
        this.reduce();
    }

    public void shift(@NotNull T trace) {
        Objects.requireNonNull(this.tops.getLast()).append(trace);
        this.tops.addLast(trace.children());
    }

    public void unshift() {
        MutableList<T> buffer = Objects.requireNonNull(this.tops.getLast());
        buffer.removeAt(buffer.size() - 1);
    }

    public void reduce() {
        this.tops.removeLast();
    }

    public void reduceAndUnshift() {
        this.tops.removeLast();
    }

    public static interface Tree<T extends Tree<T>> {
        @NotNull
        public MutableList<T> children();
    }
}

