/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record Version(@NotNull BigInteger major, @NotNull BigInteger minor, @NotNull BigInteger patch) implements Comparable<Version>,
Serializable
{
    @NotNull
    private static final Pattern DOT = Pattern.compile("\\.");

    public Version(String major, String minor, String patch) {
        this(new BigInteger(major), new BigInteger(minor), new BigInteger(patch));
    }

    public Version(long major, long minor, long patch) {
        this(BigInteger.valueOf(major), BigInteger.valueOf(minor), BigInteger.valueOf(patch));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Version create(@NotNull String version) {
        if (version.endsWith("-SNAPSHOT")) {
            version = version.substring(0, version.length() - "-SNAPSHOT".length());
        }
        String[] split = DOT.split(version.trim());
        return switch (split.length) {
            case 0 -> throw new IllegalArgumentException("Invalid version: " + version);
            case 1 -> new Version(new BigInteger(split[0]), BigInteger.ZERO, BigInteger.ZERO);
            case 2 -> new Version(new BigInteger(split[0]), new BigInteger(split[1]), BigInteger.ZERO);
            default -> new Version(new BigInteger(split[0]), new BigInteger(split[1]), new BigInteger(split[2]));
        };
    }

    @Contract(pure=true)
    @NotNull
    public String getLongString() {
        return String.valueOf(this.major) + "." + String.valueOf(this.minor) + "." + String.valueOf(this.patch);
    }

    @Override
    public String toString() {
        return BigInteger.ZERO.equals(this.patch) ? (BigInteger.ZERO.equals(this.minor) ? this.major.toString() : String.valueOf(this.major) + "." + String.valueOf(this.minor)) : String.valueOf(this.major) + "." + String.valueOf(this.minor) + "." + String.valueOf(this.patch);
    }

    @Override
    public int compareTo(Version o) {
        int i = this.major.compareTo(o.major);
        if (i != 0) {
            return i;
        }
        int j = this.minor.compareTo(o.minor);
        return j != 0 ? j : this.patch.compareTo(o.patch);
    }
}

