/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.binop;

import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.Set;
import kala.collection.mutable.MutableLinkedList;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.collection.mutable.MutableSinglyLinkedList;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.BinOpSet;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BinOpParser<OpSet extends BinOpSet, Expr extends SourceNode, Elm extends Elem<Expr>> {
    @NotNull
    protected final OpSet opSet;
    @NotNull
    private final @NotNull SeqView<@NotNull Elm> seq;
    private final MutableSinglyLinkedList<Tuple2<Elm, BinOpSet.BinOP>> opStack = MutableSinglyLinkedList.create();
    private final MutableLinkedList<Elm> prefixes = MutableLinkedList.create();
    private final MutableMap<Elm, MutableSet<AppliedSide>> appliedOperands = MutableMap.create();

    public BinOpParser(@NotNull OpSet opSet, @NotNull @NotNull SeqView<@NotNull Elm> seq) {
        this.opSet = opSet;
        this.seq = seq;
    }

    @NotNull
    protected abstract BinOpParser<OpSet, Expr, Elm> replicate(@NotNull @NotNull SeqView<@NotNull Elm> var1);

    @NotNull
    protected abstract Elm appOp();

    @NotNull
    public Expr build(@NotNull SourcePos sourcePos) {
        if (this.seq.sizeEquals(1)) {
            return (Expr)((SourceNode)((Elem)this.seq.get(0)).term());
        }
        if (this.seq.sizeEquals(2)) {
            Elem first = (Elem)this.seq.get(0);
            Elem second = (Elem)this.seq.get(1);
            if (((BinOpSet)this.opSet).assocOf(this.underlyingOpDecl(first)).isBinary()) {
                return (Expr)((SourceNode)this.makeSectionApp(sourcePos, first, elem -> this.replicate(this.seq.prepended(elem)).build(sourcePos)).term());
            }
            if (((BinOpSet)this.opSet).assocOf(this.underlyingOpDecl(second)).isBinary()) {
                return (Expr)((SourceNode)this.makeSectionApp(sourcePos, second, elem -> this.replicate(this.seq.appended(elem)).build(sourcePos)).term());
            }
        }
        return this.convertToPrefix(sourcePos);
    }

    @NotNull
    public abstract Elm makeSectionApp(@NotNull SourcePos var1, @NotNull Elm var2, @NotNull Function<Elm, Expr> var3);

    @NotNull
    private Expr convertToPrefix(@NotNull SourcePos sourcePos) {
        for (Elem expr : this.insertApplication()) {
            if (this.isOperand((Elm)expr, (BinOpSet)this.opSet)) {
                this.prefixes.append((Object)expr);
                continue;
            }
            BinOpSet.BinOP currentOp = this.toSetElem((Elm)expr, (BinOpSet)this.opSet);
            while (this.opStack.isNotEmpty()) {
                Tuple2 top = (Tuple2)this.opStack.peek();
                BinOpSet.PredCmp cmp = ((BinOpSet)this.opSet).compare((BinOpSet.BinOP)top.component2(), currentOp);
                if (cmp == BinOpSet.PredCmp.Tighter) {
                    if (this.foldLhsFor(expr)) continue;
                    return this.createErrorExpr(sourcePos);
                }
                if (cmp == BinOpSet.PredCmp.Equal) {
                    Assoc currentAssoc;
                    Assoc topAssoc = ((BinOpSet.BinOP)top.component2()).assoc();
                    if (Assoc.assocAmbiguous(topAssoc, currentAssoc = currentOp.assoc())) {
                        this.reportFixityError(topAssoc, currentAssoc, ((BinOpSet.BinOP)top.component2()).name(), currentOp.name(), this.of((Elem)top.component1()));
                        return this.createErrorExpr(sourcePos);
                    }
                    if (!topAssoc.leftAssoc()) break;
                    if (this.foldLhsFor(expr)) continue;
                    return this.createErrorExpr(sourcePos);
                }
                if (cmp == BinOpSet.PredCmp.Looser) break;
                this.reportAmbiguousPred(currentOp.name(), ((BinOpSet.BinOP)top.component2()).name(), this.of((Elem)top.component1()));
                return this.createErrorExpr(sourcePos);
            }
            this.opStack.push((Object)Tuple.of((Object)expr, (Object)currentOp));
        }
        while (this.opStack.isNotEmpty()) {
            this.foldTop();
            if (!this.opStack.isNotEmpty()) continue;
            this.markAppliedOperand((Elem)((Tuple2)this.opStack.peek()).component1(), AppliedSide.Rhs);
        }
        assert (this.prefixes.sizeEquals(1));
        return (Expr)((SourceNode)((Elem)this.prefixes.first()).term());
    }

    protected abstract void reportAmbiguousPred(String var1, String var2, SourcePos var3);

    protected abstract void reportFixityError(Assoc var1, Assoc var2, String var3, String var4, SourcePos var5);

    protected abstract void reportMissingOperand(String var1, SourcePos var2);

    @NotNull
    protected abstract Expr createErrorExpr(@NotNull SourcePos var1);

    @NotNull
    private Seq<Elm> insertApplication() {
        MutableList seqWithApp = MutableList.create();
        boolean lastIsOperand = true;
        for (Elem expr : this.seq) {
            boolean isOperand = this.isOperand((Elm)expr, (BinOpSet)this.opSet);
            if (isOperand && lastIsOperand && seqWithApp.isNotEmpty()) {
                seqWithApp.append(this.appOp());
            }
            lastIsOperand = isOperand;
            seqWithApp.append((Object)expr);
        }
        return seqWithApp;
    }

    private void markAppliedOperand(@NotNull Elm elem, @NotNull AppliedSide side) {
        ((MutableSet)this.appliedOperands.getOrPut(elem, MutableSet::of)).add((Object)side);
    }

    @NotNull
    private Set<AppliedSide> getAppliedSides(@NotNull Elm elem) {
        return (Set)this.appliedOperands.getOrPut(elem, MutableSet::of);
    }

    private boolean foldLhsFor(@NotNull Elm forOp) {
        boolean ok = this.foldTop();
        if (ok) {
            this.markAppliedOperand(forOp, AppliedSide.Lhs);
        }
        return ok;
    }

    private boolean foldTop() {
        Tuple2 opDef = (Tuple2)this.opStack.pop();
        if (((BinOpSet.BinOP)opDef.component2()).assoc().isBinary()) {
            this.prefixes.append((Object)this.foldTopBinary((Elem)opDef.component1()));
        } else {
            Elem op = (Elem)opDef.component1();
            if (this.prefixes.isEmpty()) {
                this.reportMissingOperand(((BinOpSet.BinOP)opDef.component2()).name(), ((SourceNode)op.term()).sourcePos());
                return false;
            }
            Elem operand = (Elem)this.prefixes.dequeue();
            Elem app = this.makeArg(this.union(operand, op), (SourceNode)op.term(), operand, op.explicit());
            this.prefixes.append((Object)app);
        }
        return true;
    }

    @NotNull
    private Elm foldTopBinary(@NotNull Elm op) {
        if (this.prefixes.sizeGreaterThanOrEquals(2)) {
            Elem rhs = (Elem)this.prefixes.dequeue();
            Elem lhs = (Elem)this.prefixes.dequeue();
            return (Elm)this.makeBinApp(op, rhs, lhs);
        }
        if (this.prefixes.sizeEquals(1)) {
            Set<AppliedSide> sides = this.getAppliedSides(op);
            Elem applied = (Elem)this.prefixes.dequeue();
            AppliedSide side = sides.isEmpty() ? AppliedSide.Lhs : (AppliedSide)((Object)sides.elementAt(0));
            return (Elm)this.makeSectionApp(this.union(op, applied), op, elem -> (SourceNode)(switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case AppliedSide.Lhs -> this.makeBinApp(op, elem, applied);
                case AppliedSide.Rhs -> this.makeBinApp(op, applied, elem);
            }).term());
        }
        throw new InternalError("unreachable");
    }

    @NotNull
    private Elm makeBinApp(@NotNull Elm op, @NotNull Elm rhs, @NotNull Elm lhs) {
        boolean explicit = op.explicit();
        if (op == this.appOp()) {
            return this.makeArg(this.union(lhs, rhs), (SourceNode)lhs.term(), rhs, explicit);
        }
        return this.makeArg(this.union(op, lhs, rhs), (SourceNode)this.makeArg(this.union(op, lhs), (SourceNode)op.term(), lhs, true).term(), rhs, explicit);
    }

    public boolean isOperand(@NotNull Elm elem, @NotNull BinOpSet opSet) {
        if (elem == this.appOp()) {
            return false;
        }
        OpDecl tryOp = this.underlyingOpDecl(elem);
        return opSet.isOperand(tryOp);
    }

    public @NotNull BinOpSet.BinOP toSetElem(@NotNull Elm elem, @NotNull BinOpSet opSet) {
        if (elem == this.appOp()) {
            return BinOpSet.APP_ELEM;
        }
        OpDecl tryOp = this.underlyingOpDecl(elem);
        assert (tryOp != null);
        return opSet.ensureHasElem(tryOp);
    }

    @Nullable
    protected abstract OpDecl underlyingOpDecl(@NotNull Elm var1);

    @NotNull
    protected abstract Elm makeArg(@NotNull SourcePos var1, @NotNull Expr var2, @NotNull Elm var3, boolean var4);

    @NotNull
    private SourcePos union(@NotNull Elm a, @NotNull Elm b, @NotNull Elm c) {
        return this.union(a, b).union(this.of(c));
    }

    @NotNull
    private SourcePos union(@NotNull Elm a, @NotNull Elm b) {
        return this.of(a).union(this.of(b));
    }

    @NotNull
    private SourcePos of(@NotNull Elm a) {
        return ((SourceNode)a.term()).sourcePos();
    }

    public static interface Elem<Expr> {
        @NotNull
        public Expr term();

        public boolean explicit();
    }

    static enum AppliedSide {
        Lhs,
        Rhs;

    }
}

