/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.error;

import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import kala.control.Option;
import org.aya.util.error.SourceFileLocator;
import org.jetbrains.annotations.NotNull;

public record SourceFile(@NotNull String display, @NotNull Option<Path> underlying, @NotNull String sourceCode) {
    public static final SourceFile NONE = new SourceFile("<unknown-file>", (Option<Path>)Option.none(), "");
    public static final SourceFile SER = new SourceFile("<serialized-core>", (Option<Path>)Option.none(), "");

    public SourceFile(@NotNull String display, @NotNull Path underlying, @NotNull String sourceCode) {
        this(display, (Option<Path>)Option.some((Object)underlying), StringUtil.convertLineSeparators((String)sourceCode));
    }

    @NotNull
    public static SourceFile from(@NotNull SourceFileLocator locator, @NotNull Path path) throws IOException {
        return SourceFile.from(locator, path, Files.readString(path));
    }

    @NotNull
    public static SourceFile from(@NotNull SourceFileLocator locator, @NotNull Path path, @NotNull String sourceCode) {
        return new SourceFile(locator.displayName(path).toString(), path, sourceCode);
    }

    public boolean isSomeFile() {
        return this.underlying.isDefined();
    }

    @NotNull
    public Path resolveSibling(@NotNull Path sibling) {
        return ((Path)this.underlying().getOrElse(() -> Path.of(".", new String[0]))).resolveSibling(sibling);
    }
}

