/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.error;

import java.util.Objects;
import kala.collection.SeqView;
import org.aya.pretty.error.LineColSpan;
import org.aya.pretty.error.Span;
import org.aya.util.error.Global;
import org.aya.util.error.SourceFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record SourcePos(@NotNull SourceFile file, int tokenStartIndex, int tokenEndIndex, int startLine, int startColumn, int endLine, int endColumn) implements Comparable<SourcePos>
{
    public static final SourcePos NONE = new SourcePos(SourceFile.NONE, -1, -1, -1, -1, -1, -1);
    public static final SourcePos SER = new SourcePos(SourceFile.SER, -1, -1, -1, -1, -1, -1);

    public SourcePos(@NotNull SourceFile file, int tokenStartIndex, int tokenEndIndex, int startLine, int startColumn, int endLine, int endColumn) {
        assert (tokenEndIndex >= tokenStartIndex);
    }

    @NotNull
    public Span toSpan() {
        return new LineColSpan(this.file().sourceCode(), this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    private static int min(int x, int y) {
        if (x == -1) {
            return y;
        }
        if (y == -1) {
            return x;
        }
        return Math.min(x, y);
    }

    private static int max(int x, int y) {
        if (x == -1) {
            return y;
        }
        if (y == -1) {
            return x;
        }
        return Math.max(x, y);
    }

    @Contract(value="_ -> new")
    @NotNull
    public SourcePos union(@NotNull SourcePos other) {
        return new SourcePos(this.file, SourcePos.min(this.tokenStartIndex, other.tokenStartIndex), SourcePos.max(this.tokenEndIndex, other.tokenEndIndex), SourcePos.min(this.startLine, other.startLine), this.unionStartCol(other), SourcePos.max(this.endLine, other.endLine), this.unionEndCol(other));
    }

    private int unionStartCol(@NotNull SourcePos other) {
        if (this.startLine == other.startLine) {
            return SourcePos.min(this.startColumn, other.startColumn);
        }
        if (this.startLine < other.startLine) {
            return this.startColumn;
        }
        return other.startColumn;
    }

    private int unionEndCol(@NotNull SourcePos other) {
        if (this.endLine == other.endLine) {
            return SourcePos.max(this.endColumn, other.endColumn);
        }
        if (this.endLine > other.endLine) {
            return this.endColumn;
        }
        return other.endColumn;
    }

    @Override
    public boolean equals(Object o) {
        if (Global.UNITE_SOURCE_POS || this == o) {
            return true;
        }
        if (!(o instanceof SourcePos)) {
            return false;
        }
        SourcePos sourcePos = (SourcePos)o;
        return this.tokenStartIndex == sourcePos.tokenStartIndex && this.tokenEndIndex == sourcePos.tokenEndIndex && this.startLine == sourcePos.startLine && this.startColumn == sourcePos.startColumn && this.endLine == sourcePos.endLine && this.endColumn == sourcePos.endColumn;
    }

    public boolean contains(int line, int column) {
        return line >= this.startLine && line <= this.endLine && column >= this.startColumn && column <= this.endColumn;
    }

    public boolean containsVisually(int line, int column) {
        return line >= this.startLine && line <= this.endLine && column >= this.startColumn - 1 && column <= this.endColumn;
    }

    public boolean contains(int pos) {
        return pos >= this.tokenStartIndex && pos <= this.tokenEndIndex;
    }

    public boolean containsIndex(@NotNull SourcePos x) {
        return this.tokenStartIndex <= x.tokenStartIndex && this.tokenEndIndex >= x.tokenEndIndex;
    }

    public boolean belongsToSomeFile() {
        return this != NONE && this.file.isSomeFile();
    }

    public int linesOfCode() {
        return this.endLine - this.startLine + 1;
    }

    @NotNull
    public SourcePos sourcePosForSubExpr(@NotNull SeqView<SourcePos> params) {
        return this.sourcePosForSubExpr(this.file, params);
    }

    @NotNull
    public SourcePos sourcePosForSubExpr(@NotNull SourceFile sourceFile, @NotNull SeqView<SourcePos> params) {
        SourcePos restParamSourcePos = (SourcePos)params.fold((Object)NONE, (acc, it) -> {
            if (acc == NONE) {
                return it;
            }
            return new SourcePos(sourceFile, acc.tokenStartIndex(), it.tokenEndIndex(), acc.startLine(), acc.startColumn(), it.endLine(), it.endColumn());
        });
        return new SourcePos(sourceFile, restParamSourcePos.tokenStartIndex(), this.tokenEndIndex, restParamSourcePos.startLine(), restParamSourcePos.startColumn(), this.endLine, this.endColumn);
    }

    @Override
    public String toString() {
        return "(" + this.tokenStartIndex + "-" + this.tokenEndIndex + ") [" + this.startLine + "," + this.startColumn + "-" + this.endLine + "," + this.endColumn + "]";
    }

    @Override
    public int hashCode() {
        if (Global.UNITE_SOURCE_POS) {
            return 0;
        }
        return Objects.hash(this.tokenStartIndex, this.tokenEndIndex, this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    @Override
    public int compareTo(@NotNull SourcePos o) {
        return Integer.compare(this.tokenStartIndex, o.tokenStartIndex);
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    private int size() {
        return this.tokenEndIndex - this.tokenStartIndex + 1;
    }
}

