/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.reporter;

import kala.collection.mutable.MutableList;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;

public interface CollectingReporter
extends CountingReporter {
    @NotNull
    public MutableList<Problem> problems();

    @Override
    default public int problemSize(@NotNull Problem.Severity severity) {
        return this.problems().count(it -> it.level() == severity);
    }

    @Override
    default public void clear() {
        this.problems().clear();
    }

    @NotNull
    public static CollectingReporter delegate(@NotNull Reporter delegate) {
        return new Delegated(delegate);
    }

    public record Delegated(@NotNull Reporter delegated, @NotNull MutableList<Problem> problems) implements CollectingReporter
    {
        public Delegated(@NotNull Reporter delegated) {
            this(delegated, (MutableList<Problem>)MutableList.create());
        }

        @Override
        public void report(@NotNull Problem problem) {
            this.problems.append((Object)problem);
            this.delegated.report(problem);
        }
    }
}

