/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.reporter;

import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;

public record ThrowingReporter(@NotNull PrettierOptions options) implements CountingReporter
{
    @Override
    public void report(@NotNull Problem problem) {
        String render = Reporter.errorMessage(problem, this.options, false, false, 80);
        if (problem.level() != Problem.Severity.ERROR) {
            System.err.println(render);
            return;
        }
        throw new AssertionError((Object)("Failed with `" + String.valueOf(problem.getClass()) + "`: " + render + "\nat " + String.valueOf(problem.sourcePos())));
    }

    @Override
    public int problemSize(@NotNull Problem.Severity severity) {
        return 0;
    }

    @Override
    public void clear() {
    }
}

