/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.terck;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.util.terck.CallMatrix;
import org.aya.util.terck.Diagonal;
import org.aya.util.terck.Relation;
import org.aya.util.terck.Selector;
import org.jetbrains.annotations.NotNull;

public record CallGraph<C, T, P>(@NotNull @NotNull MutableMap<T, @NotNull MutableMap<T, MutableList<@NotNull CallMatrix<C, T, P>>>> graph) {
    @NotNull
    public static <C, T, P> CallGraph<C, T, P> create() {
        return new CallGraph<C, T, P>(MutableLinkedHashMap.of());
    }

    public void put(@NotNull CallMatrix<C, T, P> matrix) {
        T caller = matrix.domain();
        T callee = matrix.codomain();
        MutableList calls = (MutableList)((MutableMap)this.graph.getOrPut(caller, MutableLinkedHashMap::of)).getOrPut(callee, MutableList::create);
        calls.append(matrix);
    }

    public boolean isEmpty() {
        return this.graph.allMatch((k, ts) -> ts.allMatch((x, t) -> t.isEmpty()));
    }

    @NotNull
    private static <C, T, P> CallGraph<C, T, P> complete(@NotNull CallGraph<C, T, P> initial) {
        CallGraph step = initial;
        CallGraph<C, T, P> comb;
        Tuple2<CallGraph<C, T, P>, CallGraph<C, T, P>> tup;
        while (!((CallGraph)(tup = CallGraph.merge(comb = CallGraph.indirect(initial, step), step)).component1()).isEmpty()) {
            step = (CallGraph)tup.component2();
        }
        return step;
    }

    @NotNull
    private static <C, T, P> CallGraph<C, T, P> indirect(@NotNull CallGraph<C, T, P> initial, @NotNull CallGraph<C, T, P> step) {
        CallGraph comb = CallGraph.create();
        initial.graph.forEach((domain, codomains) -> codomains.forEach((codomain, mats) -> mats.forEach(mat -> {
            MutableMap indirect = (MutableMap)step.graph.getOrNull(mat.codomain());
            if (indirect != null) {
                indirect.forEach((indCodomain, indMats) -> indMats.forEach(ind -> {
                    CallMatrix combine = CallMatrix.combine(mat, ind);
                    comb.put(combine);
                }));
            }
        })));
        return comb;
    }

    @NotNull
    private static <C, T, P> Tuple2<CallGraph<C, T, P>, CallGraph<C, T, P>> merge(@NotNull CallGraph<C, T, P> comb, @NotNull CallGraph<C, T, P> cs) {
        CallGraph newG = CallGraph.create();
        CallGraph oldG = CallGraph.create();
        CallGraph.forEachGraph(comb.graph, cs.graph, n -> {
            n.forEach(newG::put);
            n.forEach(oldG::put);
        }, o -> o.forEach(oldG::put), (n, o) -> {
            Tuple2 cmp = Selector.select(n.view(), o.view());
            ((ImmutableSeq)cmp.component1()).forEach(newG::put);
            ((ImmutableSeq)cmp.component1()).forEach(oldG::put);
            ((ImmutableSeq)cmp.component2()).forEach(oldG::put);
        });
        return Tuple.of(newG, oldG);
    }

    public static <K, V> void forEachGraph(@NotNull MutableMap<K, MutableMap<K, V>> a, @NotNull MutableMap<K, MutableMap<K, V>> b, @NotNull Consumer<V> inA, @NotNull Consumer<V> inB, @NotNull BiConsumer<V, V> both) {
        CallGraph.forEachMap(a, b, v1 -> v1.forEach((k, v) -> inA.accept(v)), v2 -> v2.forEach((k, v) -> inB.accept(v)), (v1, v2) -> CallGraph.forEachMap(v1, v2, inA, inB, both));
    }

    public static <K, V> void forEachMap(@NotNull MutableMap<K, V> a, @NotNull MutableMap<K, V> b, @NotNull Consumer<V> inA, @NotNull Consumer<V> inB, @NotNull BiConsumer<V, V> both) {
        MutableLinkedHashMap union = MutableLinkedHashMap.of();
        a.forEach((x$0, x$1) -> union.put(x$0, x$1));
        b.forEach((k, bv) -> {
            Option av = union.remove(k);
            if (av.isEmpty()) {
                inB.accept(bv);
            } else {
                both.accept(av.get(), bv);
            }
        });
        union.forEach((k, av) -> inA.accept(av));
    }

    @NotNull
    public ImmutableSeq<Diagonal<C, T, P>> findBadRecursion() {
        CallGraph<C, T, P> complete = CallGraph.complete(this);
        MutableList bads = MutableList.create();
        for (Object key : complete.graph.keysView()) {
            SeqView idempotent;
            ImmutableSeq bad;
            Option matrix = complete.graph.getOption(key).flatMap(g -> g.getOption(key));
            if (matrix.isEmpty() || !(bad = (idempotent = ((MutableList)matrix.get()).view().filter(m -> CallMatrix.combine(m, m).notWorseThan(m))).map(Diagonal::create).filterNot(diag -> diag.diagonal().anyMatch(Relation::isDecreasing)).toImmutableSeq()).isNotEmpty()) continue;
            bads.appendAll((Iterable)bad);
        }
        return bads.toImmutableSeq();
    }
}

