/*
 * Decompiled with CFR 0.152.
 */
package org.aya.util.tyck.pat;

import java.util.function.ObjIntConsumer;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.util.Arg;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.tyck.pat.Indexed;
import org.aya.util.tyck.pat.PatClass;
import org.jetbrains.annotations.NotNull;

public interface ClassifierUtil<Subst, Term, Param, Pat, Var> {
    public Param subst(Subst var1, Param var2);

    public Pat normalize(Pat var1);

    public Subst add(Subst var1, Var var2, Term var3);

    public Var ref(Param var1);

    @NotNull
    public ImmutableSeq<PatClass<Arg<Term>>> classify1(@NotNull Subst var1, @NotNull Param var2, @NotNull ImmutableSeq<Indexed<Pat>> var3, int var4);

    @NotNull
    default public ImmutableSeq<PatClass<ImmutableSeq<Arg<Term>>>> classifyN(@NotNull Subst subst, @NotNull SeqView<Param> params, @NotNull ImmutableSeq<Indexed<SeqView<Pat>>> clauses, int fuel) {
        if (params.isEmpty()) {
            return ImmutableSeq.of(new PatClass<ImmutableSeq>(ImmutableSeq.empty(), Indexed.indices(clauses)));
        }
        Object first = params.first();
        ImmutableSeq<PatClass<Arg<Term>>> cls = this.classify1(subst, this.subst(subst, first), clauses.mapIndexed((ix, it) -> new Indexed<Object>(this.normalize(((SeqView)it.pat()).first()), ix)), fuel);
        return cls.flatMap(subclauses -> this.classifyN(this.add(subst, this.ref(first), ((Arg)subclauses.term()).term()), params.drop(1), subclauses.extract(clauses.map(it -> new Indexed<SeqView>(((SeqView)it.pat()).drop(1), it.ix()))), fuel).map(args -> args.map(ls -> ls.prepended((Object)((Arg)subclauses.term())))));
    }

    public static int[] firstMatchDomination(@NotNull ImmutableSeq<? extends SourceNode> clauses, @NotNull ObjIntConsumer<SourcePos> report, @NotNull ImmutableSeq<? extends PatClass<?>> classes) {
        int[] numbers = new int[clauses.size()];
        classes.forEach(results -> {
            int n = results.cls().min();
            numbers[n] = numbers[n] + 1;
        });
        for (int i = 0; i < numbers.length; ++i) {
            if (0 != numbers[i]) continue;
            report.accept(((SourceNode)clauses.get(i)).sourcePos(), i + 1);
        }
        return numbers;
    }
}

