/*
 * Decompiled with CFR 0.152.
 */
package org.aya.gradle.jflex;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import jflex.core.OptionUtils;
import jflex.generator.LexGenerator;
import jflex.l10n.ErrorMessages;
import jflex.option.Options;
import jflex.skeleton.Skeleton;

public interface JFlexUtil {
    public static void invokeJflex(File outputDir, File jflex, File rootDir) throws IOException {
        JFlexUtil.setupJflex(outputDir, rootDir);
        new LexGenerator(jflex).generate();
    }

    public static void setupJflex(File outputDir, File rootDir) throws IOException {
        try (InputStream stream = JFlexUtil.class.getResourceAsStream("/jflex/aya-flex.skeleton");){
            if (!1.$assertionsDisabled && stream == null) {
                throw new AssertionError();
            }
            Skeleton.readSkel((BufferedReader)new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)));
        }
        Options.setRootDirectory((File)rootDir);
        Options.encoding = StandardCharsets.UTF_8;
        OptionUtils.setDir((File)outputDir);
        Options.no_minimize = false;
        Options.no_backup = true;
        Options.enable((ErrorMessages)ErrorMessages.MACRO_UNUSED);
        Options.enable((ErrorMessages)ErrorMessages.EMPTY_MATCH);
        Options.progress = false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

