/*
 * Decompiled with CFR 0.152.
 */
package org.aya.gradle;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public interface BuildUtil {
    public static final int JAVA_MAJOR_VERSION = 65;

    public static String gitRev(File rootDir) throws IOException, InterruptedException {
        Process proc = new ProcessBuilder("git", "rev-parse", "HEAD").directory(rootDir).start();
        proc.waitFor(3L, TimeUnit.SECONDS);
        byte[] stdout = proc.getInputStream().readAllBytes();
        byte[] stderr = proc.getErrorStream().readAllBytes();
        if (stdout.length == 0) {
            throw new IOException(new String(stderr));
        }
        return new String(stdout).trim();
    }

    public static void stripPreview(Path root, Path classFile) throws IOException {
        BuildUtil.stripPreview(root, classFile, true, true);
    }

    public static void stripPreview(Path root, Path classFile, boolean forceJava21, boolean verbose) throws IOException {
        int careSize = 8;
        FileTime time = Files.getLastModifiedTime(classFile, new LinkOption[0]);
        try (RandomAccessFile raf = new RandomAccessFile(classFile.toFile(), "rw");){
            Path relative = root.relativize(classFile.toAbsolutePath());
            MappedByteBuffer mm = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 8L);
            int magic = mm.getInt(0);
            if (magic != -889275714) {
                return;
            }
            int minor = mm.getShort(4) & 0xFFFF;
            if (minor == 65535) {
                mm.putShort(4, (short)0);
                BuildUtil.log(verbose, "AyaBuild[minor] %s: 0x%x -> 0", relative, minor);
            }
            int major = mm.getShort(6) & 0xFFFF;
            if (forceJava21 && major > 65) {
                BuildUtil.log(verbose, "AyaBuild[major] %s: %d (Java %d) -> 65 (Java 21)", relative, major, 21 + major - 65);
                mm.putShort(6, (short)65);
            }
        }
        Files.setLastModifiedTime(classFile, time);
    }

    private static void log(boolean verbose, String fmt, Object ... args) {
        if (verbose) {
            System.out.printf(fmt + "%n", args);
        }
    }
}

