/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import java.io.Serializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TextRange
implements Segment,
Serializable {
    private static final long serialVersionUID = -670091356599757430L;
    public static final TextRange EMPTY_RANGE = new TextRange(0, 0);
    public static final TextRange[] EMPTY_ARRAY = new TextRange[0];
    private final int myStartOffset;
    private final int myEndOffset;

    @Contract(pure=true)
    public TextRange(int startOffset, int endOffset) {
        this(startOffset, endOffset, true);
    }

    protected TextRange(int startOffset, int endOffset, boolean checkForProperTextRange) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        if (checkForProperTextRange) {
            TextRange.assertProperRange(this);
        }
    }

    @Override
    public final int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range = (TextRange)obj;
        return this.myStartOffset == range.myStartOffset && this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public boolean contains(@NotNull TextRange range) {
        return this.contains((Segment)range);
    }

    public boolean contains(@NotNull Segment range) {
        return this.containsRange(range.getStartOffset(), range.getEndOffset());
    }

    public boolean containsRange(int startOffset, int endOffset) {
        return this.getStartOffset() <= startOffset && endOffset <= this.getEndOffset();
    }

    public static boolean containsRange(@NotNull Segment outer, @NotNull Segment inner) {
        return outer.getStartOffset() <= inner.getStartOffset() && inner.getEndOffset() <= outer.getEndOffset();
    }

    public boolean containsOffset(int offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    public boolean contains(int offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    @NotNull
    @Contract(pure=true)
    public String substring(@NotNull String str) {
        return str.substring(this.myStartOffset, this.myEndOffset);
    }

    @NotNull
    public CharSequence subSequence(@NotNull CharSequence str) {
        return str.subSequence(this.myStartOffset, this.myEndOffset);
    }

    @NotNull
    public TextRange cutOut(@NotNull TextRange subRange) {
        if (subRange.getStartOffset() > this.getLength()) {
            throw new IllegalArgumentException("SubRange: " + subRange + "; this=" + this);
        }
        if (subRange.getEndOffset() > this.getLength()) {
            throw new IllegalArgumentException("SubRange: " + subRange + "; this=" + this);
        }
        TextRange.assertProperRange(subRange);
        return new TextRange(this.myStartOffset + subRange.getStartOffset(), Math.min(this.myEndOffset, this.myStartOffset + subRange.getEndOffset()));
    }

    @NotNull
    public TextRange shiftRight(int delta) {
        if (delta == 0) {
            return this;
        }
        return new TextRange(this.myStartOffset + delta, this.myEndOffset + delta);
    }

    @NotNull
    public TextRange shiftLeft(int delta) {
        if (delta == 0) {
            return this;
        }
        return new TextRange(this.myStartOffset - delta, this.myEndOffset - delta);
    }

    @NotNull
    public TextRange grown(int lengthDelta) {
        if (lengthDelta == 0) {
            return this;
        }
        return TextRange.from(this.myStartOffset, this.getLength() + lengthDelta);
    }

    @Contract(pure=true)
    @NotNull
    public static TextRange from(int offset, int length) {
        return TextRange.create(offset, offset + length);
    }

    @Contract(pure=true)
    @NotNull
    public static TextRange create(int startOffset, int endOffset) {
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public static TextRange create(@NotNull Segment segment) {
        return TextRange.create(segment.getStartOffset(), segment.getEndOffset());
    }

    public static boolean areSegmentsEqual(@NotNull Segment segment1, @NotNull Segment segment2) {
        return segment1.getStartOffset() == segment2.getStartOffset() && segment1.getEndOffset() == segment2.getEndOffset();
    }

    @NotNull
    public String replace(@NotNull String original, @NotNull String replacement) {
        String beginning = original.substring(0, this.getStartOffset());
        String ending = original.substring(this.getEndOffset());
        return beginning + replacement + ending;
    }

    public boolean intersects(@NotNull TextRange textRange) {
        return this.intersects((Segment)textRange);
    }

    public boolean intersects(@NotNull Segment textRange) {
        return this.intersects(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersects(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) <= Math.min(this.myEndOffset, endOffset);
    }

    public boolean intersectsStrict(@NotNull TextRange textRange) {
        return this.intersectsStrict(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersectsStrict(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) < Math.min(this.myEndOffset, endOffset);
    }

    public TextRange intersection(@NotNull TextRange range) {
        int newEnd;
        if (this.equals(range)) {
            return this;
        }
        int newStart = Math.max(this.myStartOffset, range.getStartOffset());
        return TextRange.isProperRange(newStart, newEnd = Math.min(this.myEndOffset, range.getEndOffset())) ? new TextRange(newStart, newEnd) : null;
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    @NotNull
    public TextRange union(@NotNull TextRange textRange) {
        if (this.equals(textRange)) {
            return this;
        }
        return new TextRange(Math.min(this.myStartOffset, textRange.getStartOffset()), Math.max(this.myEndOffset, textRange.getEndOffset()));
    }

    public boolean equalsToRange(int startOffset, int endOffset) {
        return startOffset == this.myStartOffset && endOffset == this.myEndOffset;
    }

    @NotNull
    public static TextRange allOf(@NotNull String s) {
        return new TextRange(0, s.length());
    }

    public static void assertProperRange(@NotNull Segment range) throws AssertionError {
        TextRange.assertProperRange(range, "");
    }

    public static void assertProperRange(@NotNull Segment range, @NotNull Object message) throws AssertionError {
        TextRange.assertProperRange(range.getStartOffset(), range.getEndOffset(), message);
    }

    public static void assertProperRange(int startOffset, int endOffset, @NotNull Object message) {
        if (!TextRange.isProperRange(startOffset, endOffset)) {
            throw new IllegalArgumentException("Invalid range specified: (" + startOffset + ", " + endOffset + "); " + message);
        }
    }

    public static boolean isProperRange(int startOffset, int endOffset) {
        return startOffset <= endOffset && startOffset >= 0;
    }
}

