/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.DefaultLogger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();

    public static void setFactory(@NotNull Class<? extends Factory> factory) {
    }

    public static Factory getFactory() {
        return ourFactory;
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    @NotNull
    public static Logger getInstance(@NotNull String category) {
        return ourFactory.getLoggerInstance(category);
    }

    @NotNull
    public static Logger getInstance(@NotNull Class cl) {
        return Logger.getInstance("#" + cl.getName());
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(String var1, @Nullable Throwable var2);

    public void debug(@NotNull String message, Object ... details) {
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            for (Object detail : details) {
                sb.append(detail);
            }
            this.debug(sb.toString());
        }
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(String message) {
        this.debug(message);
    }

    public void trace(@Nullable Throwable t) {
        this.debug(t);
    }

    public void info(@NotNull Throwable t) {
        this.info(t.getMessage(), t);
    }

    public abstract void info(String var1);

    public abstract void info(String var1, @Nullable Throwable var2);

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(String var1, @Nullable Throwable var2);

    public void error(String message) {
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(String message, String ... details) {
        this.error(message, new Throwable(message), details);
    }

    public abstract void error(String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value, @Nullable Object message) {
        if (!value) {
            Object resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = (String)resultMessage + ": " + String.valueOf(message);
            }
            this.error((String)resultMessage, new Throwable((String)resultMessage), new String[0]);
        }
        return value;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(false, null);
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            return new DefaultLogger(category);
        }
    }
}

